/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.ClassLoaderSwitchingSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.util.log.RateLimitingLogger;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;

public class JiraCacheManagerPeerProvider
extends RMICacheManagerPeerProvider {
    private static final RateLimitingLogger log = new RateLimitingLogger(JiraCacheManagerPeerProvider.class);
    private final ExecutorService executorService;
    private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);

    public JiraCacheManagerPeerProvider(CacheManager cacheManager, ExecutorService executorService) {
        super(cacheManager);
        this.executorService = executorService;
    }

    public void init() {
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public final void registerPeer(String rmiUrl) {
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        if (!this.isContainerInitialized()) {
            return Collections.emptyList();
        }
        ClusterManager clusterManager = this.getClusterManager();
        String currentNodeId = clusterManager.getNodeId();
        Collection<Node> liveNodes = clusterManager.findLiveNodes();
        return this.waitForAll(liveNodes.stream().filter(node -> node != null && !currentNodeId.equals(node.getNodeId())).map(node -> this.getCachePeerAsync(cache, (Node)node)).collect(Collectors.toList()));
    }

    private CompletableFuture<Optional<CachePeer>> getCachePeerAsync(Ehcache cache, Node node) {
        String rmiUrl = this.buildBaseUrl(node, cache.getName());
        return CompletableFuture.supplyAsync(new ClassLoaderSwitchingSupplier<Optional>(() -> {
            try {
                return Optional.of(this.lookupRemoteCachePeer(rmiUrl));
            }
            catch (RemoteException e) {
                log.warn("Looking up rmiUrl " + rmiUrl + " threw a connection exception. This could mean that a node has gone offline  or it may indicate network connectivity difficulties. Details: " + e.getMessage());
            }
            catch (MalformedURLException e) {
                log.error("Looking up rmiUrl " + rmiUrl + " through exception . Urls are not well formed. Please fix this.");
            }
            catch (NotBoundException e) {
                log.debug("Looking up rmiUrl " + rmiUrl + " threw a connection exception. This may be normal if a node has gone offline. Or it may indicate network connectivity difficulties. Details : " + e.getMessage());
            }
            return Optional.empty();
        }), this.executorService);
    }

    private <T> List<T> waitForAll(List<CompletableFuture<Optional<T>>> stages) {
        return stages.stream().map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected boolean stale(Date date) {
        return false;
    }

    private String buildBaseUrl(Node node, String cacheName) {
        return "//" + node.getIp() + ':' + node.getCacheListenerPort() + '/' + cacheName;
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.clusterManagerRef.get();
    }

    protected boolean isContainerInitialized() {
        return ComponentManager.getInstance().getState().isContainerInitialised();
    }
}

