/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.cluster.disasterrecovery.CopyTask;
import com.atlassian.jira.cluster.disasterrecovery.DeleteTask;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class JiraHomeReplicatorService
extends AbstractService
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(JiraHomeReplicatorService.class);
    private static final String NAME = JiraHomeReplicatorService.class.getName();
    private static final JobRunnerKey DELAYED_REPLICATION_KEY = JobRunnerKey.of((String)(NAME + ".delayedReplicationKey"));
    private static final JobId DELAYED_REPLICATION_ID = JobId.of((String)(NAME + ".delayedReplicationId"));
    private static final JobRunnerKey FULL_REPLICATION_KEY = JobRunnerKey.of((String)(NAME + ".fullReplicationKey"));
    private static final JobId FULL_REPLICATION_ID = JobId.of((String)(NAME + ".fullReplicationId"));
    private static final String SCHEDULED_REPLICATION_KEY = "homereplicator";
    private static final String FULL_REPLICATION_LOCK = NAME + ".fullReplicationLock";
    private static final int REPLICATOR_THREADS = 4;
    private final JiraHome jiraHome;
    private final SecondaryJiraHome secondaryJiraHome;
    private final ApplicationProperties applicationProperties;
    private final ExecutorService executorService;
    private final AttachmentPathManager attachmentPathManager;
    private final AvatarManager avatarManager;
    private final PluginPath pluginPath;
    private final SchedulerService schedulerService;
    private final ClusterLock fullReplicationLock;
    private static final EnumSet<JiraHomeChangeEvent.FileType> DELAYED_TYPES = EnumSet.of(JiraHomeChangeEvent.FileType.PLUGIN);
    private static final int DEFAULT_IDLE_SECONDS = 60;
    private final BlockingQueue<JiraHomeChangeEvent> delayedFileReplicationQueue;
    private static final File[] EMPTY_DIR = new File[0];
    private final Integer idleSeconds;

    public JiraHomeReplicatorService(JiraHome jiraHome, SecondaryJiraHome secondaryHome, ApplicationProperties applicationProperties, AttachmentPathManager attachmentPathManager, AvatarManager avatarManager, PluginPath pluginPath, ClusterLockService clusterLockService, SchedulerService schedulerService, JiraProperties jiraProperties) {
        this(jiraHome, secondaryHome, applicationProperties, attachmentPathManager, avatarManager, pluginPath, clusterLockService, schedulerService, Executors.newFixedThreadPool(4, ThreadFactories.namedThreadFactory((String)"JiraHomeReplicatorService")), jiraProperties);
    }

    @VisibleForTesting
    protected JiraHomeReplicatorService(JiraHome jiraHome, SecondaryJiraHome secondaryHome, ApplicationProperties applicationProperties, AttachmentPathManager attachmentPathManager, AvatarManager avatarManager, PluginPath pluginPath, ClusterLockService clusterLockService, SchedulerService schedulerService, ExecutorService executorService, JiraProperties jiraProperties) {
        this.jiraHome = jiraHome;
        this.secondaryJiraHome = secondaryHome;
        this.applicationProperties = applicationProperties;
        this.attachmentPathManager = attachmentPathManager;
        this.avatarManager = avatarManager;
        this.pluginPath = pluginPath;
        this.schedulerService = schedulerService;
        this.fullReplicationLock = clusterLockService.getLockForName(FULL_REPLICATION_LOCK);
        this.executorService = executorService;
        this.delayedFileReplicationQueue = new LinkedBlockingQueue<JiraHomeChangeEvent>();
        this.idleSeconds = jiraProperties.getInteger("jira.secondary.home.idleSeconds", Integer.valueOf(60));
    }

    public void start() throws Exception {
        this.schedulerService.registerJobRunner(DELAYED_REPLICATION_KEY, (JobRunner)new QueueDrainingJob());
        this.schedulerService.registerJobRunner(FULL_REPLICATION_KEY, (JobRunner)new FullReplicationJob());
    }

    @EventListener
    public void onFileChangeEvent(JiraHomeChangeEvent event) {
        if (!this.secondaryJiraHome.isEnabled()) {
            return;
        }
        JiraHomeChangeEvent.FileType fileType = event.getFileType();
        if (!this.isEnabled(fileType)) {
            return;
        }
        if (DELAYED_TYPES.contains((Object)fileType)) {
            this.queueDelayedEvent(event);
        } else {
            this.submitEvent(event);
        }
    }

    private void queueDelayedEvent(JiraHomeChangeEvent event) {
        this.delayedFileReplicationQueue.add(event);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)DELAYED_REPLICATION_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)DateTime.now().plusSeconds(this.idleSeconds.intValue()).toDate()));
        try {
            this.schedulerService.scheduleJob(DELAYED_REPLICATION_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule delayed replication", (Throwable)e);
        }
    }

    private void submitEvent(JiraHomeChangeEvent event) {
        if (event.getAction() == JiraHomeChangeEvent.Action.FILE_ADD) {
            for (File file : event.getFiles()) {
                this.submitCopyTask(file);
            }
        } else {
            for (File file : event.getFiles()) {
                this.submitDeleteTask(file);
            }
        }
    }

    private Future<?> submitDeleteTask(File file) {
        log.debug("submitDeleteTask: file={}", (Object)file);
        return this.executorService.submit(new DeleteTask(file, this.jiraHome, this.secondaryJiraHome));
    }

    private Future<?> submitCopyTask(File file) {
        log.debug("submitCopyTask: file={}", (Object)file);
        return this.executorService.submit(new CopyTask(file, this.jiraHome, this.secondaryJiraHome, this.executorService));
    }

    @EventListener
    public void shutdown(ComponentManagerShutdownEvent shutdownEvent) {
        this.shutdown();
    }

    private void shutdown() {
        log.debug("Shutting down");
        do {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.debug("Replication service has not shut down; cancelling replications in progress.");
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        throw new RuntimeException("Replicate executor did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } while (!this.executorService.isTerminated());
    }

    private boolean isEnabled(JiraHomeChangeEvent.FileType fileType) {
        return this.applicationProperties.getOption(fileType.getKey());
    }

    public boolean isReplicating() {
        if (this.fullReplicationLock.tryLock()) {
            this.fullReplicationLock.unlock();
            return false;
        }
        return true;
    }

    public void replicateJiraHome() throws SchedulerServiceException {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)FULL_REPLICATION_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null));
        this.schedulerService.scheduleJob(FULL_REPLICATION_ID, jobConfig);
    }

    public void run() {
        this.performReplication();
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration(SCHEDULED_REPLICATION_KEY, "services/com/atlassian/jira/service/services/homereplicator.xml", null);
    }

    @VisibleForTesting
    void drainQueue() {
        ArrayList events = new ArrayList(this.delayedFileReplicationQueue.size());
        this.delayedFileReplicationQueue.drainTo(events);
        for (JiraHomeChangeEvent jiraHomeChangeEvent : events) {
            this.submitEvent(jiraHomeChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    Map<JiraHomeChangeEvent.FileType, ReplicationResult> performReplication() {
        try {
            if (!this.fullReplicationLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                log.debug("Full replication is already in progress; aborting...");
                return null;
            }
        }
        catch (InterruptedException e) {
            log.debug("Full replication is already in progress; aborting...");
            return null;
        }
        try {
            log.debug("Replicating Jira Home with secondary home...");
            EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult> results = new EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult>(JiraHomeChangeEvent.FileType.class);
            for (JiraHomeChangeEvent.FileType fileType : JiraHomeChangeEvent.FileType.values()) {
                this.replicateFileType(results, fileType);
            }
            log.debug("Jira Home replicated");
            EnumMap<JiraHomeChangeEvent.FileType, ReplicationResult> enumMap = results;
            return enumMap;
        }
        finally {
            this.fullReplicationLock.unlock();
        }
    }

    private void replicateFileType(Map<JiraHomeChangeEvent.FileType, ReplicationResult> results, JiraHomeChangeEvent.FileType fileType) {
        if (this.isEnabled(fileType)) {
            log.debug("Replicating: {}", (Object)fileType);
            ReplicationResult result = fileType.replicate(this);
            results.put(fileType, result);
            log.debug("Replicated {}: {}", (Object)fileType, (Object)result);
        } else {
            log.debug("Not replicated: {}", (Object)fileType);
        }
    }

    ReplicationResult replicateAttachments() {
        return this.replicateDir(new File(this.attachmentPathManager.getAttachmentPath()));
    }

    ReplicationResult replicateAvatars() {
        return this.replicateDir(this.avatarManager.getAvatarBaseDirectory());
    }

    ReplicationResult replicateIndexSnapshots() {
        return this.replicateDir(new File(this.jiraHome.getExportDirectory().getAbsolutePath(), "indexsnapshots"));
    }

    ReplicationResult replicatePlugins() {
        ReplicationResult replicationResult = this.replicateDir(this.pluginPath.getInstalledPluginsDirectory());
        File source = this.pluginPath.getPluginsFreezeFile();
        this.replicateFile(replicationResult, source);
        return replicationResult;
    }

    private void replicateFile(ReplicationResult replicationResult, File source) {
        File destination = new File(StringUtils.replaceOnce((String)source.getAbsolutePath(), (String)this.jiraHome.getHomePath(), (String)this.secondaryJiraHome.getHomePath()));
        boolean sourceExists = source.exists();
        boolean destinationExists = destination.exists();
        if (sourceExists) {
            replicationResult.incrementSourceFileCount();
        }
        if (destinationExists) {
            replicationResult.incrementDestinationFileCount();
        }
        if (sourceExists && (!destinationExists || source.length() != destination.length())) {
            replicationResult.incrementCopiedFileCount();
            this.submitCopyTask(source);
        } else if (!sourceExists && destinationExists) {
            replicationResult.incrementDeletedFileCount();
            this.submitDeleteTask(source);
        }
    }

    private ReplicationResult replicateDir(File sourceDir) {
        String sourcePath = sourceDir.getAbsolutePath();
        File destinationDir = new File(StringUtils.replaceOnce((String)sourcePath, (String)this.jiraHome.getHomePath(), (String)this.secondaryJiraHome.getHomePath()));
        String destPath = destinationDir.getAbsolutePath();
        ReplicationResult result = new ReplicationResult();
        if (destPath.startsWith(sourcePath)) {
            result.setError(new IllegalStateException("Destination [" + destPath + "] is a subdirectory of source [" + sourcePath + "]"));
        } else if (sourcePath.startsWith(destPath)) {
            result.setError(new IllegalStateException("Source [" + sourcePath + "] is a subdirectory of destination [" + destPath + "]"));
        } else {
            this.replicateContents(sourceDir, destinationDir, result);
        }
        return result;
    }

    private void replicateContents(File sourceDir, File destinationDir, ReplicationResult result) {
        HashMap<String, File> filesToProcess = new HashMap<String, File>();
        HashMap<String, File> dirsToProcess = new HashMap<String, File>();
        this.processSourceDir(sourceDir, result, filesToProcess, dirsToProcess);
        this.processDestinationDir(destinationDir, result, filesToProcess, dirsToProcess);
        for (File file : filesToProcess.values()) {
            result.incrementCopiedFileCount();
            this.submitCopyTask(file);
        }
        for (File file : dirsToProcess.values()) {
            this.replicateContents(file, null, result);
        }
    }

    private void processDestinationDir(File destinationDir, ReplicationResult result, Map<String, File> filesToProcess, Map<String, File> dirsToProcess) {
        File[] destinationFiles;
        for (File file : destinationFiles = this.getFiles(destinationDir)) {
            File original;
            if (file.isDirectory()) {
                original = dirsToProcess.remove(file.getName());
                this.replicateContents(original, file, result);
                continue;
            }
            result.incrementDestinationFileCount();
            original = filesToProcess.remove(file.getName());
            if (original == null) {
                result.incrementDeletedFileCount();
                File deletedFile = new File(StringUtils.replaceOnce((String)file.getAbsolutePath(), (String)this.secondaryJiraHome.getHomePath(), (String)this.jiraHome.getHomePath()));
                this.submitDeleteTask(deletedFile);
                continue;
            }
            if (original.length() == file.length()) continue;
            result.incrementCopiedFileCount();
            this.submitCopyTask(original);
        }
    }

    private void processSourceDir(File sourceDir, ReplicationResult result, Map<String, File> filesToProcess, Map<String, File> dirsToProcess) {
        File[] sourceFiles;
        for (File file : sourceFiles = this.getFiles(sourceDir)) {
            if (file.isDirectory()) {
                dirsToProcess.put(file.getName(), file);
                continue;
            }
            result.incrementSourceFileCount();
            filesToProcess.put(file.getName(), file);
        }
    }

    @Nonnull
    private File[] getFiles(@Nullable File dir) {
        if (dir == null) {
            return EMPTY_DIR;
        }
        File[] result = dir.listFiles();
        if (result == null) {
            return EMPTY_DIR;
        }
        return result;
    }

    public class FullReplicationJob
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            Map<JiraHomeChangeEvent.FileType, ReplicationResult> result = JiraHomeReplicatorService.this.performReplication();
            if (result == null) {
                return JobRunnerResponse.aborted((String)"Full replication is already in progress");
            }
            return JobRunnerResponse.success((String)result.toString());
        }
    }

    public class QueueDrainingJob
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            JiraHomeReplicatorService.this.drainQueue();
            return JobRunnerResponse.success();
        }
    }

    public static class ReplicationResult {
        private int sourceFileCount;
        private int destinationFileCount;
        private int copiedFileCount;
        private int deletedFileCount;
        private Exception error;

        public void incrementSourceFileCount() {
            ++this.sourceFileCount;
        }

        public void incrementDestinationFileCount() {
            ++this.destinationFileCount;
        }

        public void incrementCopiedFileCount() {
            ++this.copiedFileCount;
        }

        public void incrementDeletedFileCount() {
            ++this.deletedFileCount;
        }

        public void setError(Exception error) {
            this.error = error;
        }

        public int getSourceFileCount() {
            return this.sourceFileCount;
        }

        public int getDestinationFileCount() {
            return this.destinationFileCount;
        }

        public int getCopiedFileCount() {
            return this.copiedFileCount;
        }

        public int getDeletedFileCount() {
            return this.deletedFileCount;
        }

        public Exception getError() {
            return this.error;
        }

        public String toString() {
            return "ReplicationResult{sourceFileCount=" + this.sourceFileCount + ", destinationFileCount=" + this.destinationFileCount + ", copiedFileCount=" + this.copiedFileCount + ", deletedFileCount=" + this.deletedFileCount + '}';
        }
    }
}

