/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

class ClassLoaderSwitchingRunnable
implements Runnable {
    private final Runnable runnable;
    private final ClassLoader taskClassLoader;

    ClassLoaderSwitchingRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.taskClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void run() {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.taskClassLoader);
            this.runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
    }
}

