/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

import com.atlassian.jira.cluster.cache.ehcache.ClassLoaderSwitchingRunnable;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingParallelCacheReplicator
implements CacheReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingParallelCacheReplicator.class);
    private volatile Status status;
    private final boolean replicatePuts;
    private final boolean replicatePutsViaCopy;
    private final boolean replicateUpdates;
    private final boolean replicateUpdatesViaCopy;
    private final boolean replicateRemovals;
    private final ExecutorService executorService;

    BlockingParallelCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, ExecutorService executorService) {
        this.replicatePuts = replicatePuts;
        this.replicatePutsViaCopy = replicatePutsViaCopy;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.executorService = executorService;
        this.status = Status.STATUS_ALIVE;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return true;
    }

    public boolean notAlive() {
        return !this.alive();
    }

    public boolean alive() {
        return Status.STATUS_ALIVE.equals(this.status);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            LOG.warn("Key {} is not Serializable and removal cannot be replicated. Cache: {}", element.getObjectKey(), (Object)cache.getName());
            return;
        }
        this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicatePuts) {
            return;
        }
        if (this.replicatePutsViaCopy) {
            this.replicateViaCopy(cache, element);
        } else {
            this.replicateViaKeyInvalidation(cache, element);
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                LOG.warn("Object with key {} is not Serializable and cannot be updated via copy. Cache: {}", element.getObjectKey(), (Object)cache.getName());
                return;
            }
            this.replicatePutNotification(cache, element);
        } else {
            if (!element.isKeySerializable()) {
                LOG.warn("Key {} is not Serializable and update cannot be replicated. Cache: {}", element.getObjectKey(), (Object)cache.getName());
                return;
            }
            this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive() || !this.replicateRemovals) {
            return;
        }
        this.replicateRemoveAllNotification(cache);
    }

    private void replicateViaCopy(Ehcache cache, Element element) {
        if (element.isSerializable()) {
            this.replicatePutNotification(cache, element);
            return;
        }
        if (!element.isKeySerializable()) {
            this.logUnserializableKey(element);
        }
        if (!this.isValueSerializable(element)) {
            LOG.error("Value class {} is not Serializable => cannot be replicated. Cache: {}", (Object)element.getObjectValue().getClass().getName(), (Object)cache.getName());
        }
    }

    private boolean isValueSerializable(Element element) {
        return element.getObjectValue() instanceof Serializable;
    }

    private void replicateViaKeyInvalidation(Ehcache cache, Element element) {
        if (element.isKeySerializable()) {
            this.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
            return;
        }
        this.logUnserializableKey(element);
    }

    private void replicatePutNotification(Ehcache cache, Element element) throws RemoteCacheException {
        this.forEachCachePeer(cache, peer -> {
            try {
                peer.put(element);
            }
            catch (Throwable t) {
                this.onReplicationError(cache, (CachePeer)peer, t, "put");
            }
        });
    }

    private void replicateRemovalNotification(Ehcache cache, Serializable key) throws RemoteCacheException {
        this.forEachCachePeer(cache, peer -> {
            try {
                peer.remove(key);
            }
            catch (Throwable t) {
                this.onReplicationError(cache, (CachePeer)peer, t, "remove");
            }
        });
    }

    private void replicateRemoveAllNotification(Ehcache cache) {
        this.forEachCachePeer(cache, peer -> {
            try {
                peer.removeAll();
            }
            catch (Throwable t) {
                this.onReplicationError(cache, (CachePeer)peer, t, "removeAll");
            }
        });
    }

    protected void onReplicationError(Ehcache cache, CachePeer peer, Throwable t, String operation) {
        LOG.error("Exception on replication of {}. {}. Cache: {} Peer: {}", new Object[]{operation, t.getMessage(), cache.getName(), this.getPeerName(peer), t});
    }

    private String getPeerName(CachePeer peer) {
        try {
            return peer.getName();
        }
        catch (RemoteException e) {
            return "undefined";
        }
    }

    private void forEachCachePeer(Ehcache cache, Consumer<CachePeer> operation) {
        List cachePeers = cache.getCacheManager().getCacheManagerPeerProvider("RMI").listRemoteCachePeers(cache);
        CompletableFuture.allOf((CompletableFuture[])cachePeers.stream().map(peer -> CompletableFuture.runAsync(new ClassLoaderSwitchingRunnable(() -> operation.accept((CachePeer)peer)), this.executorService)).toArray(CompletableFuture[]::new)).join();
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    private void logUnserializableKey(Element element) {
        LOG.error("Key class {} is not Serializable => cannot be replicated", (Object)element.getObjectKey().getClass().getName());
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new BlockingParallelCacheReplicator(this.replicatePuts, this.replicatePutsViaCopy, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.executorService);
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }
}

