/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

public class Message {
    public static final String DELIMITER = ":-";
    private final String channel;
    private final String supplementalInformation;

    public Message(String channel, String supplementalInformation) {
        this.channel = channel;
        this.supplementalInformation = supplementalInformation;
    }

    public static Message fromString(String message) {
        String channel;
        String supplementalInformation;
        int separatorIndex = message.indexOf(DELIMITER);
        if (separatorIndex > 0) {
            supplementalInformation = message.substring(separatorIndex + DELIMITER.length());
            channel = message.substring(0, separatorIndex);
        } else {
            supplementalInformation = null;
            channel = message;
        }
        return new Message(channel, supplementalInformation);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public String toString() {
        return this.serializeAsString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.channel.equals(message.channel) && this.isSameSupplementalInformation(message);
    }

    private boolean isSameSupplementalInformation(Message message) {
        return this.supplementalInformation == null ? message.supplementalInformation == null : this.supplementalInformation.equals(message.supplementalInformation);
    }

    public int hashCode() {
        int result = this.channel.hashCode();
        result = 31 * result + (this.supplementalInformation != null ? this.supplementalInformation.hashCode() : 0);
        return result;
    }

    private String serializeAsString() {
        StringBuilder sb = new StringBuilder(this.channel);
        if (this.supplementalInformation != null) {
            sb.append(DELIMITER);
            sb.append(this.supplementalInformation);
        }
        return sb.toString();
    }
}

