/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultClusterNodes
implements ClusterNodes {
    @ClusterSafe
    private final ResettableLazyReference<Node> nodeRef = new ResettableLazyReference<Node>(){

        protected Node create() {
            return DefaultClusterNodes.this.initializeNode();
        }
    };
    private final ClusterNodeProperties clusterNodeProperties;
    private final OfBizClusterNodeStore ofBizClusterNodeStore;
    private final String hostname;
    private final long nodeBuildNumber;
    private final String nodeVersion;

    public DefaultClusterNodes(ClusterNodeProperties clusterNodeProperties, OfBizClusterNodeStore ofBizClusterNodeStore, BuildUtilsInfo buildUtilsInfo) {
        this.clusterNodeProperties = clusterNodeProperties;
        this.ofBizClusterNodeStore = ofBizClusterNodeStore;
        this.hostname = this.buildHostname();
        this.nodeBuildNumber = buildUtilsInfo.getApplicationBuildNumber();
        this.nodeVersion = buildUtilsInfo.getVersion();
    }

    @Override
    public Node current() {
        return (Node)this.nodeRef.get();
    }

    @Override
    public void reset() {
        this.nodeRef.reset();
    }

    @Override
    public Set<Node> all() {
        return ImmutableSet.copyOf(this.ofBizClusterNodeStore.getAllNodes());
    }

    Node initializeNode() {
        String nodeId = this.clusterNodeProperties.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Node.NOT_CLUSTERED;
        }
        return this.getOrCreateNode(nodeId);
    }

    private Node getOrCreateNode(String nodeId) {
        Node node = this.ofBizClusterNodeStore.getNode(nodeId);
        if (node == null) {
            node = this.ofBizClusterNodeStore.createNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort(), this.nodeBuildNumber, this.nodeVersion);
        } else if (this.stateHasChanged(node)) {
            node = this.ofBizClusterNodeStore.updateNode(nodeId, Node.NodeState.ACTIVE, this.hostname, this.getCacheListenerPort(), this.nodeBuildNumber, this.nodeVersion);
        }
        return node;
    }

    protected boolean stateHasChanged(Node node) {
        return node.getState() == Node.NodeState.OFFLINE || !StringUtils.equalsIgnoreCase((CharSequence)this.hostname, (CharSequence)node.getIp()) || !Objects.equal((Object)node.getCacheListenerPort(), (Object)this.getCacheListenerPort()) || !Objects.equal((Object)node.getNodeBuildNumber(), (Object)this.nodeBuildNumber);
    }

    protected Long getCacheListenerPort() {
        String port = this.clusterNodeProperties.getProperty("ehcache.listener.port");
        return Long.valueOf(port != null ? port : "40001");
    }

    @VisibleForTesting
    protected String buildHostname() {
        String hostname = this.clusterNodeProperties.getProperty("ehcache.listener.hostName");
        return hostname != null ? hostname : JiraUtils.getHostname();
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }
}

