/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.cache.CacheLoader;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheImpl;
import java.io.Closeable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestCacheController {
    private static final ThreadLocal<CacheContext> CACHE_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    public static void startContext() {
        CacheContext existing = RequestCacheController.getContext();
        if (existing == null) {
            CACHE_CONTEXT_THREAD_LOCAL.set(new CacheContext());
        } else {
            existing.reopen();
        }
    }

    public static void closeContext() {
        CacheContext existing = RequestCacheController.getContext();
        if (existing == null) {
            throw new IllegalStateException("closeContext() without a matching startContext()");
        }
        existing.close();
    }

    public static void clearAll() {
        CacheContext existing = RequestCacheController.getContext();
        if (existing != null) {
            existing.clearAll();
        }
    }

    public static boolean isInContext() {
        return RequestCacheController.getContext() != null;
    }

    @Nullable
    static CacheContext getContext() {
        return CACHE_CONTEXT_THREAD_LOCAL.get();
    }

    public static void process(Runnable runnable) {
        RequestCacheController.startContext();
        try {
            runnable.run();
        }
        finally {
            RequestCacheController.closeContext();
        }
    }

    static <K, V> RequestCache<K, V> createRequestCache(@Nonnull String name, @Nonnull CacheLoader<K, V> cacheLoader) {
        return new RequestCacheImpl<K, V>(name, cacheLoader);
    }

    static class CacheContext
    implements Closeable {
        private final Map<RequestCache<?, ?>, Map<Object, Object>> mapOfCaches = new IdentityHashMap();
        private int nesting = 0;

        CacheContext() {
        }

        @Nonnull
        Map<Object, Object> getLocalMap(RequestCache<?, ?> requestCache) {
            Map<Object, Object> cache = this.mapOfCaches.get(requestCache);
            if (cache == null) {
                cache = new HashMap<Object, Object>();
                this.mapOfCaches.put(requestCache, cache);
            }
            return cache;
        }

        @Nullable
        Map<Object, Object> getLocalMapIfExists(RequestCache<?, ?> requestCache) {
            return this.mapOfCaches.get(requestCache);
        }

        void clearAll() {
            this.mapOfCaches.clear();
        }

        void clearLocalMap(RequestCache<?, ?> requestCache) {
            this.mapOfCaches.remove(requestCache);
        }

        void reopen() {
            ++this.nesting;
        }

        @Override
        public void close() {
            if (this.nesting > 0) {
                --this.nesting;
            } else {
                CACHE_CONTEXT_THREAD_LOCAL.remove();
            }
        }
    }
}

