/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.vcache.VCacheFactory;
import java.util.Optional;
import java.util.function.Supplier;

public class SwitchingCacheFactoryImpl
implements SwitchingCacheFactory {
    private final InstanceFeatureManager instanceFeatureManager;
    private final VCacheFactory vCacheFactory;
    private final CacheManager cacheManager;

    public SwitchingCacheFactoryImpl(InstanceFeatureManager instanceFeatureManager, VCacheFactory vCacheFactory, CacheManager cacheManager) {
        this.instanceFeatureManager = instanceFeatureManager;
        this.vCacheFactory = vCacheFactory;
        this.cacheManager = cacheManager;
    }

    @Override
    public <K, V> CacheAdapter<K, V> buildSwitchingRequestCache(String cacheName, Optional<CacheSettings> cacheSettings, String darkFeatureKey) {
        if (this.instanceFeatureManager.isInstanceFeatureEnabled(darkFeatureKey) || this.instanceFeatureManager.isInstanceFeatureEnabled("jira.vertigo.big.bang.enable.request.caches")) {
            return CacheAdapter.of(this.vCacheFactory.getRequestCache(cacheName));
        }
        if (cacheSettings.isPresent()) {
            return CacheAdapter.of(this.cacheManager.getCache(cacheName, null, cacheSettings.get()));
        }
        return CacheAdapter.of(this.cacheManager.getCache(cacheName));
    }

    @Override
    public <V> SingleValueLocalCache<V> buildSwitchingRequestCache(String cacheName, Supplier<V> supplier, String darkFeatureKey) {
        if (this.instanceFeatureManager.isInstanceFeatureEnabled(darkFeatureKey) || this.instanceFeatureManager.isInstanceFeatureEnabled("jira.vertigo.big.bang.enable.request.caches")) {
            return SingleValueLocalCache.of(this.vCacheFactory.getRequestCache(cacheName), supplier);
        }
        return SingleValueLocalCache.of(this.cacheManager.getCachedReference(cacheName, supplier::get));
    }
}

