/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.jira.cache.JiraVCacheInitialisationUtils;
import com.atlassian.vcache.internal.NameValidator;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.DefaultRequestContext;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class JiraVCacheRequestContextSupplier
implements Supplier<RequestContext> {
    private static final Logger log = LoggerFactory.getLogger(JiraVCacheRequestContextSupplier.class);
    private static final ThreadLocal<RequestContext> staticContext = new ThreadLocal();
    private final NoopRequestContext noopContext = new NoopRequestContext();
    private final ThreadLocal<RequestContext> threadRequestContexts = new ThreadLocal();
    private final boolean warnNoContext;

    public JiraVCacheRequestContextSupplier(boolean warnNoContext) {
        this.warnNoContext = warnNoContext;
    }

    @Override
    @Nonnull
    public RequestContext get() {
        RequestContext current = this.threadRequestContexts.get();
        if (current == null) {
            return this.handleNoRequestContext();
        }
        return current;
    }

    public boolean isInitilised() {
        return this.threadRequestContexts.get() != null;
    }

    private RequestContext handleNoRequestContext() {
        if (staticContext.get() != null) {
            return staticContext.get();
        }
        if (this.warnNoContext) {
            log.warn("Asked for request context when not initialised.", (Throwable)new RuntimeException("VCache context no initialised - using NOOP context."));
        }
        return this.noopContext;
    }

    public void initThread(String partitionId) {
        RequestContext current = this.threadRequestContexts.get();
        if (current != null) {
            log.error("Asked to initialise thread {} that is already initialised!", (Object)Thread.currentThread().getName());
            throw new IllegalStateException("Thread '" + Thread.currentThread().getName() + "' has already been initialised.");
        }
        log.trace("Initialise request context");
        this.threadRequestContexts.set((RequestContext)new DefaultRequestContext(NameValidator.requireValidPartitionIdentifier((String)partitionId)));
    }

    public void clearThread() {
        RequestContext current = this.threadRequestContexts.get();
        if (log.isDebugEnabled() && current == null) {
            log.debug("Asked to clear a thread that is already clear!", (Throwable)new RuntimeException());
        }
        this.threadRequestContexts.remove();
    }

    public static void initStaticContext(String partitionId) {
        staticContext.set((RequestContext)new DefaultRequestContext(NameValidator.requireValidPartitionIdentifier((String)partitionId)));
    }

    public static void clearStaticContext() {
        staticContext.remove();
    }

    static class NoopRequestContext
    implements RequestContext {
        NoopRequestContext() {
        }

        @Nonnull
        public String partitionIdentifier() {
            return JiraVCacheInitialisationUtils.getFakeTenant().getId();
        }

        @Nonnull
        public <T> T computeIfAbsent(Object key, Supplier<T> supplier) {
            return supplier.get();
        }

        @Nonnull
        public <T> Optional<T> get(Object key) {
            return Optional.empty();
        }
    }
}

