/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.Cache;
import com.atlassian.vcache.LocalCacheOperations;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface CacheAdapter<K, V>
extends LocalCacheOperations<K, V> {
    public static <K, V> CacheAdapter<K, V> of(final LocalCacheOperations<K, V> cache) {
        return new CacheAdapter<K, V>(){

            @Nonnull
            public Optional<V> get(K key) {
                return cache.get(key);
            }

            @Nonnull
            public V get(K key, Supplier<? extends V> supplier) {
                return cache.get(key, supplier);
            }

            public void put(K key, V value) {
                cache.put(key, value);
            }

            @Nonnull
            public Optional<V> putIfAbsent(K key, V value) {
                return cache.putIfAbsent(key, value);
            }

            public boolean replaceIf(K key, V currentValue, V newValue) {
                return cache.replaceIf(key, currentValue, newValue);
            }

            public boolean removeIf(K key, V value) {
                return cache.removeIf(key, value);
            }

            public void remove(K key) {
                cache.remove(key);
            }

            public void removeAll() {
                cache.removeAll();
            }
        };
    }

    public static <K, V> CacheAdapter<K, V> of(final Cache<K, V> cache) {
        return new CacheAdapter<K, V>(){

            @Nonnull
            public Optional<V> get(K key) {
                return Optional.ofNullable(cache.get(key));
            }

            @Nonnull
            public V get(K key, Supplier<? extends V> supplier) {
                return cache.get(key, () -> supplier.get());
            }

            public void put(K key, V value) {
                cache.put(key, value);
            }

            @Nonnull
            public Optional<V> putIfAbsent(K key, V value) {
                return Optional.ofNullable(cache.putIfAbsent(key, value));
            }

            public boolean replaceIf(K key, V currentValue, V newValue) {
                return cache.replace(key, currentValue, newValue);
            }

            public boolean removeIf(K key, V value) {
                return cache.remove(key, value);
            }

            public void remove(K key) {
                cache.remove(key);
            }

            public void removeAll() {
                cache.removeAll();
            }
        };
    }
}

