/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.board.BoardWorkflowService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.Query;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBoardWorkflowService
implements BoardWorkflowService {
    private final SearchService searchService;
    private final ProjectManager projectManager;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DefaultBoardWorkflowService(SearchService searchService, ProjectManager projectManager, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager) {
        this.searchService = searchService;
        this.projectManager = projectManager;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public Set<Status> getAccessibleStatuses(ApplicationUser user, Query query) {
        Collection<JiraWorkflow> workflows = this.getWorkflowsForQuery(user, query);
        return this.allStatusesFromWorkflowCollection(workflows);
    }

    public Set<Status> getAllActiveWorkflowStatuses() {
        Collection activeWorkflows = this.workflowManager.getActiveWorkflows();
        return this.allStatusesFromWorkflowCollection(activeWorkflows);
    }

    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj) {
        return this.getJiraWorkflows(projectObj, null);
    }

    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj, String issueTypeId) {
        try {
            AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(projectObj);
            if (issueTypeId == null) {
                return this.getWorkflowsFromWorkflowScheme((WorkflowScheme)workflowScheme);
            }
            return Collections.singleton(this.workflowManager.getWorkflowFromScheme((WorkflowScheme)workflowScheme, issueTypeId));
        }
        catch (DataAccessException e) {
            this.logger.error("Tried to retrieve workflows for a project and got an error: %s", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<Status> getInitialStatusesForQuery(ApplicationUser user, Query query) {
        return (Set)this.getWorkflowsForQuery(user, query).stream().map(this::getInitialStatusesForWorkflow).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    @NotNull
    public Collection<JiraWorkflow> getWorkflowsForQuery(@NotNull ApplicationUser user, @NotNull Query query) {
        Collection<QueryContext.ProjectIssueTypeContexts> contexts = this.getProjectIssueTypeContextsForQuery(user, query);
        if (this.containsGlobalContext(contexts)) {
            return this.workflowManager.getActiveWorkflows();
        }
        return (Collection)contexts.stream().map(this::getWorkflowsForProjectIssueTypeContext).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<Status> allStatusesFromWorkflowCollection(Collection<JiraWorkflow> workflows) {
        return (Set)workflows.stream().map(JiraWorkflow::getLinkedStatusObjects).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private boolean containsGlobalContext(Collection<QueryContext.ProjectIssueTypeContexts> contexts) {
        return contexts.stream().anyMatch(context -> context.getProjectContext().isAll());
    }

    private Collection<QueryContext.ProjectIssueTypeContexts> getProjectIssueTypeContextsForQuery(ApplicationUser user, Query query) {
        return this.searchService.getQueryContext(user, query).getProjectIssueTypeContexts();
    }

    private Set<JiraWorkflow> getWorkflowsForProjectIssueTypeContext(QueryContext.ProjectIssueTypeContexts context) {
        Long projectId = context.getProjectContext().getProjectId();
        Project project = this.projectManager.getProjectObj(projectId);
        Set issueTypeIdsInContext = (Set)context.getIssueTypeContexts().stream().map(IssueTypeContext::getIssueTypeId).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
        Sets.SetView issueTypeIdsInProject = this.getIssueTypeIdsInProject(project);
        Sets.SetView issueTypeIdsInProjectAndContext = issueTypeIdsInContext.isEmpty() ? issueTypeIdsInProject : Sets.intersection((Set)issueTypeIdsInContext, issueTypeIdsInProject);
        return this.getWorkflowsForProjectAndIssueTypeIds(project, (Set<String>)issueTypeIdsInProjectAndContext);
    }

    private Set<JiraWorkflow> getWorkflowsForProjectAndIssueTypeIds(Project project, Set<String> issueTypes) {
        return (Set)issueTypes.stream().map(issueTypeId -> this.getJiraWorkflows(project, (String)issueTypeId)).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<String> getIssueTypeIdsInProject(Project project) {
        return (Set)project.getIssueTypes().stream().map(issueType -> issueType.getId()).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<Status> getInitialStatusesForWorkflow(JiraWorkflow workflow) {
        List initialActions = workflow.getDescriptor().getInitialActions();
        return (Set)initialActions.stream().map(actionDescriptor -> actionDescriptor.getUnconditionalResult().getStep()).map(stepId -> workflow.getDescriptor().getStep(stepId.intValue())).map(arg_0 -> ((JiraWorkflow)workflow).getLinkedStatus(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
    }

    private Collection<JiraWorkflow> getWorkflowsFromWorkflowScheme(@NotNull WorkflowScheme workflowScheme) {
        Set result = this.workflowManager.getWorkflowsFromScheme(this.workflowSchemeManager.getSchemeObject(workflowScheme.getId()));
        if (result == null) {
            result = Collections.emptySet();
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(result, (Predicate)Predicates.notNull()));
    }
}

