/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.user.ApplicationUserBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class ApplicationUserBuilderImpl
implements ApplicationUserBuilder {
    private final ApplicationUser user;
    private boolean active;
    private String name;
    private String emailAddress;
    private String displayName;

    public ApplicationUserBuilderImpl(ApplicationUser user) {
        this.user = user;
        this.active = user.isActive();
    }

    @Nonnull
    public ApplicationUserBuilder active(boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    public ApplicationUserBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nonnull
    public ApplicationUser build() {
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)this.user.getDirectoryUser());
        userBuilder.name(StringUtils.defaultIfBlank((String)this.name, (String)this.user.getName()));
        userBuilder.emailAddress(StringUtils.defaultIfBlank((String)this.emailAddress, (String)this.user.getEmailAddress()));
        userBuilder.displayName(StringUtils.defaultIfBlank((String)this.displayName, (String)this.user.getDisplayName()));
        userBuilder.active(this.active);
        return new DelegatingApplicationUser(this.user.getId(), this.user.getKey(), userBuilder.toUser());
    }
}

