/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.util.TextUtils;

public class DefaultFieldScreenService
implements FieldScreenService {
    private final I18nHelper.BeanFactory i18nFactory;
    private final FieldScreenManager fieldScreenManager;
    private final PermissionManager permissionManager;

    public DefaultFieldScreenService(I18nHelper.BeanFactory i18nFactory, FieldScreenManager fieldScreenManager, PermissionManager permissionManager) {
        this.i18nFactory = i18nFactory;
        this.fieldScreenManager = fieldScreenManager;
        this.permissionManager = permissionManager;
    }

    public ServiceOutcome<FieldScreen> copy(FieldScreen screenToCopy, String copyName, String copyDescription, ApplicationUser loggedInUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        if (!TextUtils.stringSet((String)copyName)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.common.errors.validname"));
        }
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.screens.no.permission"));
        }
        for (FieldScreen fieldScreen : this.fieldScreenManager.getFieldScreens()) {
            if (!copyName.equals(fieldScreen.getName())) continue;
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.screens.duplicate.screen.name"));
        }
        FieldScreenImpl copy = new FieldScreenImpl(this.fieldScreenManager, null);
        copy.setName(copyName);
        copy.setDescription(copyDescription);
        copy.store();
        for (FieldScreenTab fieldScreenTab : screenToCopy.getTabs()) {
            FieldScreenTab copyFieldScreenTab = copy.addTab(fieldScreenTab.getName());
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                copyFieldScreenTab.addFieldScreenLayoutItem(fieldScreenLayoutItem.getFieldId());
            }
        }
        return ServiceOutcomeImpl.ok(copy);
    }
}

