/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingTaggingAvatarStore
implements AvatarStore {
    private static final Logger log = LoggerFactory.getLogger(CachingTaggingAvatarStore.class);
    public static final String AVATAR_ENTITY = "Avatar";
    public static final String ID = "id";
    public static final String FILE_NAME = "fileName";
    public static final String CONTENT_TYPE = "contentType";
    public static final String AVATAR_TYPE = "avatarType";
    public static final String OWNER = "owner";
    public static final String SYSTEM_AVATAR = "systemAvatar";
    private static final String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    private static final int IS_SYSTEM = 1;
    private static final int NOT_SYSTEM = 0;
    private final Cache<Long, Optional<Avatar>> avatars;
    private final Cache<Long, Optional<Avatar>> taggedAvatars;
    private final Cache<String, ImmutableListMultimap<String, Avatar>> systemAvatars;
    private final OfBizDelegator ofBizDelegator;
    private final AvatarTagger avatarTagger;

    public CachingTaggingAvatarStore(OfBizDelegator ofBizDelegator, AvatarTagger avatarTagger, CacheManager cacheManager) {
        this.taggedAvatars = cacheManager.getCache(this.getClass().getName() + ".taggedAvatars");
        this.avatars = cacheManager.getCache(this.getClass().getName() + ".avatars");
        this.systemAvatars = cacheManager.getCache(this.getClass().getName() + ".systemAvatars", iconTypeKey -> (ImmutableListMultimap)this.getAvatars((Map<String, ?>)FieldMap.build((String)SYSTEM_AVATAR, (Object)1, (String)AVATAR_TYPE, (Object)iconTypeKey)).stream().collect(CollectorsUtil.toImmutableListMultiMap(Avatar::getFileName, Function.identity())));
        this.ofBizDelegator = ofBizDelegator;
        this.avatarTagger = avatarTagger;
    }

    private Optional<Avatar> checkForTaggedVersionOrFallbackToDb(@Nonnull Long id) {
        return Optional.ofNullable(this.taggedAvatars.get((Object)id)).flatMap(Optional::of).orElseGet(() -> Optional.ofNullable(this.gvToAvatar(this.ofBizDelegator.findById(AVATAR_ENTITY, id))));
    }

    private Optional<Avatar> tagAndRetrieve(@Nullable Long id) {
        GenericValue gv = this.ofBizDelegator.findById(AVATAR_ENTITY, id);
        if (gv == null) {
            return Optional.empty();
        }
        this.tagLegacyAvatar(gv);
        return Optional.of(this.gvToAvatar(gv));
    }

    @Override
    public Avatar getById(Long avatarId) {
        return ((Optional)this.avatars.get((Object)avatarId, () -> this.checkForTaggedVersionOrFallbackToDb(avatarId))).orElse(null);
    }

    @Override
    public Avatar getByIdTagged(Long avatarId) {
        try {
            Avatar avatar = ((Optional)this.taggedAvatars.get((Object)avatarId, () -> this.tagAndRetrieve(avatarId))).orElse(null);
            return avatar;
        }
        finally {
            this.avatars.remove((Object)avatarId);
        }
    }

    @Override
    public boolean delete(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        try {
            boolean bl = this.ofBizDelegator.removeByAnd(AVATAR_ENTITY, (Map)FieldMap.build((String)ID, (Object)avatarId)) != 0;
            return bl;
        }
        finally {
            this.taggedAvatars.remove((Object)avatarId);
            this.avatars.remove((Object)avatarId);
            this.systemAvatars.removeAll();
        }
    }

    @Override
    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Long avatarId = (Long)Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getIconType());
        Assertions.notNull((String)"avatar.owner", (Object)avatar.getOwner());
        GenericValue gv = this.ofBizDelegator.findById(AVATAR_ENTITY, avatarId);
        gv.setNonPKFields(this.getNonPkFields(avatar));
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            this.taggedAvatars.remove((Object)avatarId);
            this.avatars.remove((Object)avatarId);
            this.systemAvatars.removeAll();
        }
    }

    @Override
    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getIconType());
        Avatar createdAvatar = this.gvToAvatar(this.ofBizDelegator.createValue(AVATAR_ENTITY, this.getNonPkFields(avatar)));
        this.taggedAvatars.remove((Object)createdAvatar.getId());
        this.avatars.remove((Object)createdAvatar.getId());
        if (createdAvatar.isSystemAvatar()) {
            this.systemAvatars.remove((Object)createdAvatar.getIconType().getKey());
        }
        return createdAvatar;
    }

    @Override
    public List<Avatar> getAllSystemAvatars(IconType iconType) {
        Assertions.notNull((String)"iconType", (Object)iconType);
        return ImmutableList.copyOf((Collection)((ImmutableListMultimap)this.systemAvatars.get((Object)iconType.getKey())).values());
    }

    @Override
    public List<Avatar> getCustomAvatarsForOwner(IconType iconType, String ownerId) {
        Assertions.notNull((String)"iconType", (Object)iconType);
        Assertions.notNull((String)"ownerId", (Object)ownerId);
        return this.getAvatars((Map<String, ?>)FieldMap.build((String)SYSTEM_AVATAR, (Object)0, (String)AVATAR_TYPE, (Object)iconType.getKey(), (String)OWNER, (Object)ownerId));
    }

    @Override
    public List<Avatar> getSystemAvatarsForFilename(IconType iconType, String filename) throws DataAccessException {
        Assertions.notNull((String)"iconType", (Object)iconType);
        Assertions.notNull((String)"filename", (Object)filename);
        return ((ImmutableListMultimap)this.systemAvatars.get((Object)iconType.getKey())).get((Object)filename);
    }

    private List<Avatar> getAvatars(Map<String, ?> constraint) {
        return this.ofBizDelegator.findByAnd(AVATAR_ENTITY, constraint).stream().map(this::gvToAvatar).collect(Collectors.toList());
    }

    private Map<String, Object> getNonPkFields(Avatar avatar) {
        return MapBuilder.newBuilder().add((Object)FILE_NAME, (Object)avatar.getFileName()).add((Object)CONTENT_TYPE, (Object)avatar.getContentType()).add((Object)AVATAR_TYPE, (Object)avatar.getIconType().getKey()).add((Object)OWNER, (Object)avatar.getOwner()).add((Object)SYSTEM_AVATAR, (Object)(avatar.isSystemAvatar() ? 1 : 0)).toMutableMap();
    }

    Avatar gvToAvatar(GenericValue gv) {
        if (gv == null) {
            return null;
        }
        IconType iconType = IconType.of((String)gv.getString(AVATAR_TYPE));
        if (iconType == null) {
            log.error("Could not get icon type for name " + gv.getString(AVATAR_TYPE));
        }
        return new AvatarImpl(gv.getLong(ID), gv.getString(FILE_NAME), gv.getString(CONTENT_TYPE), iconType, gv.getString(OWNER), gv.getInteger(SYSTEM_AVATAR) != 0);
    }

    void tagLegacyAvatar(GenericValue gv) {
        String fileName = gv.getString(FILE_NAME);
        Long id = gv.getLong(ID);
        Integer isSystem = gv.getInteger(SYSTEM_AVATAR);
        String avatarType = gv.getString(AVATAR_TYPE);
        if (isSystem.equals(1) || !avatarType.equals(IconType.USER_ICON_TYPE.getKey()) || fileName.endsWith(TAGGED_AVATAR_FILE_SUFFIX)) {
            return;
        }
        try {
            String newFileName = this.avatarTagger.tagAvatar(id, fileName);
            gv.setString(FILE_NAME, newFileName);
            gv.setString(CONTENT_TYPE, "image/png");
        }
        catch (IOException | RuntimeException e) {
            log.warn("Could not convert avatar {} to new format with metadata.\nThis avatar may be deleted during an upgrade to the next major version of JIRA.\nAlso, if this avatar is embedded in reply emails picked up by the JIRA email handler, the handler may attach the avatar file to the associated issue", (Object)fileName);
            return;
        }
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.taggedAvatars.removeAll();
        this.avatars.removeAll();
        this.systemAvatars.removeAll();
    }
}

