/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.avatar.MD5Util;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.DefaultBaseUrl;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServiceImpl
implements AvatarService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvatarServiceImpl.class);
    private static final String HTTP_API = "http://www.gravatar.com/avatar/";
    private static final String HTTPS_API = "https://secure.gravatar.com/avatar/";
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final GravatarSettings gravatarSettings;
    private final BaseUrl baseUrl;
    private final EncodingConfiguration encodingConfiguration;
    @ClusterSafe
    private final LazyReference<Avatar.Size> defaultAvatarSize = new LazyReference<Avatar.Size>(){

        protected Avatar.Size create() throws Exception {
            return Avatar.Size.defaultSize();
        }
    };

    public AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, GravatarSettings gravatarSettings, EncodingConfiguration encodingConfiguration) {
        this.baseUrl = new DefaultBaseUrl(velocityRequestContextFactory);
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.gravatarSettings = gravatarSettings;
        this.encodingConfiguration = encodingConfiguration;
    }

    private static ApplicationUser fromStaleUser(ApplicationUser user) {
        try {
            return user;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public Avatar getAvatar(ApplicationUser remoteUser, String username) throws AvatarsDisabledException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            Avatar anonymousAvatar = this.getAnonymousAvatar();
            LOGGER.debug("User with key '{}' does not exist, using anonymous avatar id {}", (Object)username, (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
            return anonymousAvatar;
        }
        return this.getAvatarImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, user, false);
    }

    private Avatar getAvatarImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser user, boolean tagged) {
        if (this.userManager.isUserExisting(user)) {
            Long customAvatarId = this.configuredAvatarIdFor(user);
            if (customAvatarId != null) {
                Avatar avatar;
                Avatar avatar2 = avatar = tagged ? this.avatarManager.getByIdTagged(customAvatarId) : this.avatarManager.getById(customAvatarId);
                if (avatar != null && (skipPermissionCheck || this.canViewAvatar(remoteUser, avatar))) {
                    return avatar;
                }
            }
            Avatar defaultAvatar = this.getDefaultAvatar();
            LOGGER.debug("Avatar not configured for user '{}', using default id {}", (Object)user.getUsername(), (Object)(defaultAvatar != null ? defaultAvatar.getId() : null));
            return defaultAvatar;
        }
        Avatar anonymousAvatar = this.getAnonymousAvatar();
        LOGGER.debug("User is null, using anonymous avatar id {}", (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
        return anonymousAvatar;
    }

    private boolean canViewAvatar(ApplicationUser user, Avatar avatar) {
        return this.avatarManager.userCanView(user, avatar);
    }

    private Avatar getDefaultAvatar() {
        return this.avatarManager.getDefaultAvatar(IconType.USER_ICON_TYPE);
    }

    public Avatar getAvatar(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        if (avatarUser == null) {
            return this.getAnonymousAvatar();
        }
        return this.getAvatarImpl(remoteUser, false, avatarUser, false);
    }

    public Avatar getAvatarTagged(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        if (avatarUser == null) {
            return this.getAnonymousAvatar();
        }
        return this.getAvatarImpl(remoteUser, false, avatarUser, true);
    }

    public URI getAvatarURL(ApplicationUser remoteUser, String username) throws AvatarsDisabledException {
        return this.getAvatarURL(AvatarServiceImpl.fromStaleUser(remoteUser), this.userManager.getUserByName(username));
    }

    public Optional<URI> getGravatarAvatarURL(ApplicationUser avatarUser, Avatar.Size size) {
        if (this.isGravatarEnabled() && avatarUser != null && avatarUser.getEmailAddress() != null) {
            String hash = MD5Util.md5Hex(avatarUser.getEmailAddress().toLowerCase());
            String apiAddress = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)this.gravatarSettings.getCustomApiAddress()), (Object)(this.useSSL() ? HTTPS_API : HTTP_API));
            return Optional.of(URI.create(apiAddress + hash + "?d=mm&s=" + Integer.toString(size.getPixels())));
        }
        return Optional.empty();
    }

    private boolean useSSL() {
        String baseURL = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        try {
            return "https".equalsIgnoreCase(URI.create(baseURL).getScheme());
        }
        catch (Exception e) {
            return false;
        }
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, (Avatar.Size)this.defaultAvatarSize.get());
    }

    private URI getAvatarURLImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser avatarUser, Avatar.Size size) {
        boolean useGravatars = this.isUsingExternalAvatar(remoteUser, avatarUser);
        UrlStrategy urlStrategy = useGravatars ? new GravatarUrlStrategy() : new JiraUrlStrategy(skipPermissionCheck);
        return urlStrategy.get(remoteUser, avatarUser, size != null ? size : (Avatar.Size)this.defaultAvatarSize.get());
    }

    public URI getAvatarURL(ApplicationUser remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size);
    }

    public URI getAvatarUrlNoPermCheck(String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarUrlNoPermCheck(ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, avatarUser, size);
    }

    public URI getAvatarUrlNoPermCheck(ApplicationUser avatarUser, Avatar avatar, @Nonnull Avatar.Size size) {
        if (this.useGravatarFor(avatar)) {
            return new GravatarUrlStrategy().get(avatarUser, avatarUser, size);
        }
        return this.buildUriForAvatar(avatar, size);
    }

    public URI getAvatarAbsoluteURL(ApplicationUser remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarAbsoluteURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size);
    }

    public boolean hasCustomUserAvatar(ApplicationUser remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.hasCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean hasCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        return remoteUser != null && (this.configuredAvatarIdFor(user) != null || this.isUsingExternalAvatar(remoteUser, user));
    }

    public void setCustomUserAvatar(ApplicationUser remoteUser, String username, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        this.setCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user, avatarId);
    }

    public void setCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        if (!this.canSetCustomUserAvatar(remoteUser, user)) {
            throw new NoPermissionException();
        }
        this.setConfiguredAvatarIdFor(user, avatarId);
    }

    public boolean canSetCustomUserAvatar(ApplicationUser remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.canSetCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean canSetCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        IconType iconType = IconType.USER_ICON_TYPE;
        return this.avatarManager.userCanCreateFor(remoteUser, iconType, new IconOwningObjectId(user.getKey()));
    }

    public URI getProjectAvatarURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    public URI getProjectAvatarAbsoluteURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    private URI getProjectAvatarURLImpl(Project project, Avatar.Size size, String baseUrl) {
        Long avatarId;
        Avatar avatar = project.getAvatar();
        Long l = avatarId = avatar == null ? null : avatar.getId();
        if (avatarId.equals(this.avatarManager.getDefaultAvatarId(IconType.PROJECT_ICON_TYPE))) {
            return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
        }
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("pid", (Object)project.getId());
        urlBuilder.addParameter("avatarId", avatarId.toString());
        return urlBuilder.asURI();
    }

    public URI getProjectDefaultAvatarURL(Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
    }

    public URI getProjectDefaultAvatarAbsoluteURL(Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
    }

    private URI getProjectDefaultAvatarURLImpl(Avatar.Size size, String baseUrl) {
        Long defaultAvatarId;
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        if ((defaultAvatarId = this.avatarManager.getDefaultAvatarId(IconType.PROJECT_ICON_TYPE)) != null) {
            urlBuilder.addParameter("avatarId", defaultAvatarId.toString());
        }
        return urlBuilder.asURI();
    }

    protected Long configuredAvatarIdFor(ApplicationUser user) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        if (userProperties.exists("user.avatar.id")) {
            long avatarId = userProperties.getLong("user.avatar.id");
            LOGGER.debug("Avatar configured for user '{}' is {}", (Object)user.getUsername(), (Object)avatarId);
            return avatarId;
        }
        return null;
    }

    public boolean isGravatarEnabled() {
        return this.gravatarSettings.isAllowGravatars();
    }

    public boolean isUsingExternalAvatar(ApplicationUser remoteUser, ApplicationUser avatarUser) {
        if (this.isGravatarEnabled()) {
            Avatar avatar = this.getAvatarImpl(remoteUser, true, avatarUser, false);
            return this.useGravatarFor(avatar);
        }
        return false;
    }

    private boolean useGravatarFor(Avatar avatar) {
        Avatar defaultAvatar = this.getDefaultAvatar();
        return this.isGravatarEnabled() && (avatar == null || Objects.equal((Object)avatar, (Object)defaultAvatar));
    }

    protected void setConfiguredAvatarIdFor(ApplicationUser user, Long avatarId) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        userProperties.setLong("user.avatar.id", avatarId.longValue());
        LOGGER.debug("Set configured avatar id for user '{}' to {}", (Object)user.getUsername(), (Object)avatarId);
    }

    protected Avatar getAnonymousAvatar() {
        Long anonAvatarId = this.avatarManager.getAnonymousAvatarId();
        return anonAvatarId != null ? this.avatarManager.getById(anonAvatarId) : null;
    }

    private URI buildUriForAvatar(Avatar avatar, @Nonnull Avatar.Size size) {
        Long avatarId;
        String ownerId;
        String base = this.baseUrl.getCanonicalBaseUrl();
        UrlBuilder builder = new UrlBuilder(base + "/secure/useravatar", this.encodingConfiguration.getEncoding(), false);
        if (size != Avatar.Size.defaultSize()) {
            builder.addParameter("size", size.getParam());
        }
        String string = ownerId = avatar != null ? avatar.getOwner() : null;
        if (ownerId != null) {
            builder.addParameter("ownerId", ownerId);
        }
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            builder.addParameter("avatarId", avatarId.toString());
        }
        return builder.asURI();
    }

    private class JiraUrlStrategy
    implements UrlStrategy {
        private final boolean skipPermissionCheck;

        JiraUrlStrategy(boolean skipPermissionCheck) {
            this.skipPermissionCheck = skipPermissionCheck;
        }

        @Override
        public URI get(ApplicationUser remoteUser, ApplicationUser user, @Nonnull Avatar.Size size) {
            Avatar avatar = AvatarServiceImpl.this.getAvatarImpl(remoteUser, this.skipPermissionCheck, user, false);
            return AvatarServiceImpl.this.buildUriForAvatar(avatar, size);
        }
    }

    public class GravatarUrlStrategy
    implements UrlStrategy {
        @Override
        public URI get(ApplicationUser remoteUser, ApplicationUser user, @Nonnull Avatar.Size size) {
            return AvatarServiceImpl.this.getGravatarAvatarURL(user, size).orElseGet(() -> AvatarServiceImpl.this.buildUriForAvatar(AvatarServiceImpl.this.getAnonymousAvatar(), size));
        }
    }

    private static interface UrlStrategy {
        public URI get(ApplicationUser var1, ApplicationUser var2, @Nonnull Avatar.Size var3);
    }
}

