/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ApplicationRoleDiff {
    @VisibleForTesting
    static final Comparator<ChangedValueImpl> CHANGED_VALUE_COMPARATOR = (o1, o2) -> {
        int names = o1.getName().compareTo(o2.getName());
        if (names != 0) {
            return names;
        }
        int froms = ApplicationRoleDiff.compare(o1.getFrom(), o2.getFrom());
        if (froms != 0) {
            return froms;
        }
        return ApplicationRoleDiff.compare(o1.getTo(), o2.getTo());
    };
    private final ApplicationKey key;
    private final Set<Group> removedGroups;
    private final Set<Group> reportableRemovedDefaultGroups;
    private final Set<Group> newGroups;
    private final Set<Group> reportableNewDefaultGroups;
    private final Optional<Boolean> selectedByDefault;

    @Nonnull
    public static ApplicationRoleDiff diffRemoved(@Nonnull ApplicationRole role) {
        Optional<Boolean> selectedByDefault = role.isSelectedByDefault() ? Optional.of(false) : Optional.empty();
        return new ApplicationRoleDiff(role.getKey(), role.getGroups(), role.getDefaultGroups(), Collections.emptySet(), Collections.emptySet(), selectedByDefault);
    }

    @Nonnull
    public static ApplicationRoleDiff diff(@Nonnull Option<ApplicationRole> oldRole, @Nonnull ApplicationRole newRole) {
        if (oldRole.isEmpty()) {
            Optional<Boolean> selectedByDefault = newRole.isSelectedByDefault() ? Optional.of(true) : Optional.empty();
            return new ApplicationRoleDiff(newRole.getKey(), Collections.emptySet(), Collections.emptySet(), newRole.getGroups(), newRole.getDefaultGroups(), selectedByDefault);
        }
        ApplicationRole old = (ApplicationRole)oldRole.get();
        if (!newRole.getKey().equals((Object)old.getKey())) {
            throw new IllegalArgumentException("Old and new role keys must match. Old key: '" + old.getKey() + "'. New key: '" + newRole.getKey() + "'.");
        }
        Sets.SetView removedGroups = Sets.difference((Set)old.getGroups(), (Set)newRole.getGroups());
        Sets.SetView removedDefaultGroups = Sets.difference((Set)old.getDefaultGroups(), (Set)newRole.getDefaultGroups());
        Sets.SetView addedGroups = Sets.difference((Set)newRole.getGroups(), (Set)old.getGroups());
        Sets.SetView addedDefaultGroups = Sets.difference((Set)newRole.getDefaultGroups(), (Set)old.getDefaultGroups());
        Optional<Boolean> selectedByDefault = Optional.of(newRole.isSelectedByDefault()).filter((!old.isSelectedByDefault())::equals);
        return new ApplicationRoleDiff(newRole.getKey(), (Set<Group>)removedGroups, (Set<Group>)removedDefaultGroups, (Set<Group>)addedGroups, (Set<Group>)addedDefaultGroups, selectedByDefault);
    }

    @VisibleForTesting
    static int compare(@Nullable String left, @Nullable String right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    private ApplicationRoleDiff(ApplicationKey key, Set<Group> removedGroups, Set<Group> reportableRemovedDefaultGroups, Set<Group> newGroups, Set<Group> reportableNewDefaultGroups, Optional<Boolean> selectedByDefault) {
        this.key = key;
        this.removedGroups = ImmutableSet.copyOf(removedGroups);
        this.reportableRemovedDefaultGroups = ImmutableSet.copyOf(reportableRemovedDefaultGroups);
        this.newGroups = ImmutableSet.copyOf(newGroups);
        this.reportableNewDefaultGroups = ImmutableSet.copyOf(reportableNewDefaultGroups);
        this.selectedByDefault = selectedByDefault;
    }

    public String summary() {
        return String.format("Changed access configuration of %s", this.key.value());
    }

    public List<ChangedValue> messages() {
        List extraGroupValues = this.newGroups.stream().map(group -> new ChangedValueImpl(group.getName(), "Not associated", this.reportableNewDefaultGroups.contains(group) ? "Associated (default)" : "Associated")).collect(Collectors.toList());
        List removedGroupValues = this.removedGroups.stream().map(group -> new ChangedValueImpl(group.getName(), this.reportableRemovedDefaultGroups.contains(group) ? "Associated (default)" : "Associated", "Not associated")).collect(Collectors.toList());
        List removedDefaultGroups = this.reportableRemovedDefaultGroups.stream().filter(group -> !this.removedGroups.contains(group)).map(group -> new ChangedValueImpl(group.getName(), "Associated (default)", "Associated")).collect(Collectors.toList());
        List newDefaultGroups = this.reportableNewDefaultGroups.stream().filter(group -> !this.newGroups.contains(group)).map(group -> new ChangedValueImpl(group.getName(), "Associated", "Associated (default)")).collect(Collectors.toList());
        ArrayList messages = Lists.newArrayList();
        messages.addAll(extraGroupValues);
        messages.addAll(removedGroupValues);
        messages.addAll(removedDefaultGroups);
        messages.addAll(newDefaultGroups);
        if (this.selectedByDefault.isPresent()) {
            Boolean defaultApp = this.selectedByDefault.get();
            messages.add(new ChangedValueImpl("Default application for new users", Boolean.valueOf(defaultApp == false).toString(), defaultApp.toString()));
        }
        return messages;
    }

    public boolean isEmpty() {
        return this.messages().isEmpty();
    }
}

