/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractAmendment
implements Amendment {
    private int type;
    private String message;
    private String bugId;

    protected AbstractAmendment(int type, String bugId, String message) {
        if (!this.isValidType(type)) {
            throw new IllegalArgumentException("Unknown type '" + type + "'.");
        }
        this.bugId = bugId;
        this.message = message;
        this.type = type;
    }

    @Override
    public boolean isCorrection() {
        return this.getType() == 0;
    }

    @Override
    public boolean isWarning() {
        return this.getType() == 1;
    }

    @Override
    public boolean isError() {
        return this.getType() == 2;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected boolean isValidType(int type) {
        return type == 0 || type == 2 || type == 1;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getBugId() {
        return this.bugId;
    }

    protected void setBugId(String bugId) {
        this.bugId = bugId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractAmendment)) {
            return false;
        }
        AbstractAmendment abstractAmendment = (AbstractAmendment)o;
        if (this.type != abstractAmendment.type) {
            return false;
        }
        if (this.bugId != null ? !this.bugId.equals(abstractAmendment.bugId) : abstractAmendment.bugId != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(abstractAmendment.message) : abstractAmendment.message != null);
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 29 * result + (this.bugId != null ? this.bugId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

