/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.help.StaticHelpUrls;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.startup.StartupCheck;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectionUrlCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(MySqlConnectionUrlCheck.class);
    private final ConfigurationState configurationState;

    public MySqlConnectionUrlCheck(ConfigurationState configurationState) {
        this.configurationState = configurationState;
    }

    @Override
    public String getName() {
        return "MySql connection url configuration check";
    }

    @Override
    public boolean isOk() {
        if (!this.configurationState.isConfigurationAvailable()) {
            return true;
        }
        Optional<String> connectionUri = this.configurationState.getConnectionUri();
        if (this.configurationState.isMySql() && connectionUri.isPresent() && !this.configurationState.isUriMySql57Compatible(connectionUri.get())) {
            if (this.canWorkWithCurrentConfiguration()) {
                log.warn(this.getFaultDescription());
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canWorkWithCurrentConfiguration() {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException e) {
            log.error("Exception occurred while trying to connect to the database: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DatabaseUtil.closeQuietly(connection);
        }
        return true;
    }

    private Connection getConnection() throws SQLException {
        return DefaultOfBizConnectionFactory.getInstance().getConnection();
    }

    @Override
    @Nullable
    public String getFaultDescription() {
        return "You have an error in your dbconfig.xml file. Missing \"default_storage_engine\" in connection url. The \"storage_engine\" parameter is deprecated and should be replaced with  \"default_storage_engine\".Please refer to the " + this.getDocumentationLink() + ".";
    }

    @Override
    @Nullable
    public String getHTMLFaultDescription() {
        return "<p>You have an error in your dbconfig.xml file. Missing \"default_storage_engine\" in connection url. The \"storage_engine\" parameter is deprecated and should be replaced with  \"default_storage_engine\".Please refer to the <a href=\"" + this.getDocumentationLink() + ">JIRA database documentation</a>.</p>";
    }

    String getDocumentationLink() {
        return StaticHelpUrls.getInstance().getUrl("mysql").getUrl();
    }

    public static class ConfigurationState {
        private final DatabaseConfigurationManager databaseConfigurationManager;

        public ConfigurationState(DatabaseConfigurationManager databaseConfigurationManager) {
            this.databaseConfigurationManager = databaseConfigurationManager;
        }

        boolean isConfigurationAvailable() {
            return this.databaseConfigurationManager.isDatabaseSetup();
        }

        Optional<String> getConnectionUri() {
            return Optional.ofNullable(this.databaseConfigurationManager.getDatabaseConfiguration()).map(DatabaseConfig::getDatasourceInfo).map(DatasourceInfo::getJdbcDatasource).map(JdbcDatasourceInfo::getUri);
        }

        boolean isUriMySql57Compatible(String uri) {
            String query = URIUtil.getQuery((String)uri);
            return StringUtils.contains((CharSequence)query, (CharSequence)"default_storage_engine");
        }

        public boolean isMySql() {
            return this.databaseConfigurationManager.getDatabaseConfiguration().isMySql();
        }
    }
}

