/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.startup.StartupCheck;

public class EmbeddedDatabaseTypeCheck
implements StartupCheck {
    private final DatabaseConfig databaseConfiguration;

    public EmbeddedDatabaseTypeCheck(DatabaseConfig databaseConfiguration) {
        this.databaseConfiguration = databaseConfiguration;
    }

    @Override
    public String getName() {
        return "Embedded database support check";
    }

    @Override
    public boolean isOk() {
        return !this.databaseConfiguration.isHSql();
    }

    @Override
    public String getFaultDescription() {
        StringBuilder message = new StringBuilder(512);
        message.append("Failed to start due to problems with your database configuration. HSQL is no longer supported.");
        message.append("In order to migrate your HSQL database to supported H2 database, please run JIRA 7.0 which will trigger migration procedure.");
        return message.toString();
    }

    @Override
    public String getHTMLFaultDescription() {
        StringBuilder message = new StringBuilder(512);
        message.append("<p>Failed to start due to problems with your database configuration. HSQL is no longer supported.</p>");
        message.append("<p>In order to migrate your HSQL database to supported H2 database, please run JIRA 7.0 which will trigger migration procedure.</p>");
        return message.toString();
    }

    @Override
    public void stop() {
    }
}

