/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.DatabaseCollationReader;
import com.atlassian.jira.database.SupportedCollations;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.startup.StartupCheck;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(CollationCheck.class);
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final OfBizConnectionFactory connectionFactory;
    private final JiraProperties jiraProperties;
    private final WarningLogger warningLogger;

    public CollationCheck(DatabaseConfigurationManager databaseConfigurationManager, OfBizConnectionFactory connectionFactory, JiraProperties jiraProperties) {
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.jiraProperties = jiraProperties;
        this.connectionFactory = connectionFactory;
        this.warningLogger = new WarningLogger();
    }

    @Override
    public String getName() {
        return "Database collation check.";
    }

    @Override
    public boolean isOk() {
        try (Connection connection = this.connectionFactory.getConnection();){
            DatabaseConfig databaseConfig = this.databaseConfigurationManager.getDatabaseConfiguration();
            String collation = DatabaseCollationReader.findCollation(connection, databaseConfig);
            if (!SupportedCollations.isSupported(databaseConfig, collation)) {
                Collection<String> supportedCollationsList = SupportedCollations.forDatabase(databaseConfig);
                if (!supportedCollationsList.isEmpty()) {
                    String supportedCollationsString = StringUtils.join(supportedCollationsList, (String)" or ");
                    this.showBigWarning(String.format("You are using an unsupported %s collation: %s. This may cause some functionality to not work.\n", this.getDatabaseType(), collation) + String.format("Please use %s as the collation instead.", supportedCollationsString));
                } else {
                    this.showBigWarning("Your database is not supported. This may cause some functionality to not work");
                }
            }
        }
        catch (Exception e) {
            this.showBigWarning("The database collation could not be read. An unsupported collation could cause some functionality to not work");
            log.info("Exception when reading database collation", (Throwable)e);
        }
        return true;
    }

    private String getDatabaseType() {
        return this.databaseConfigurationManager.getDatabaseConfiguration().getDatabaseType();
    }

    @Override
    public String getFaultDescription() {
        return null;
    }

    @Override
    public String getHTMLFaultDescription() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private void showBigWarning(String message) {
        this.getWarningLogger().showWarning(message);
    }

    @VisibleForTesting
    WarningLogger getWarningLogger() {
        return this.warningLogger;
    }

    @VisibleForTesting
    class WarningLogger {
        WarningLogger() {
        }

        public void showWarning(String message) {
            String lineOfStars = StringUtils.repeat((String)"*", (int)100);
            String newLine = CollationCheck.this.jiraProperties.getProperty("line.separator");
            String warning = newLine + newLine + lineOfStars + newLine + message + newLine + lineOfStars + newLine;
            log.warn(warning);
        }
    }
}

