/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.bc.dataimport.DowngradeWorker;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.DbConnectionManagerImpl;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.MissingDowngradeTaskException;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryManager;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildVersionCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(BuildVersionCheck.class);
    private static final String NAME = "JIRA Build Version Check";
    private static final String JIRA_IGNORE_BUILD_VERSION = "jira.ignore.buildversion";
    private final JiraProperties jiraSystemProperties;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final UpgradeVersionHistoryManager upgradeVersionHistoryManager;
    private String faultDescription = null;
    private String htmlFaultDescription = null;

    public BuildVersionCheck(JiraProperties jiraSystemProperties, DatabaseConfigurationManager databaseConfigurationManager, BuildUtilsInfo buildUtilsInfo, UpgradeVersionHistoryManager upgradeVersionHistoryManager) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.upgradeVersionHistoryManager = upgradeVersionHistoryManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        if (this.jiraSystemProperties.getBoolean(JIRA_IGNORE_BUILD_VERSION).booleanValue()) {
            log.warn("Not performing Jira Build Version check since jira.ignore.buildversion is set to 'true'");
        } else if (this.databaseSetup()) {
            log.debug("Performing version check");
            int applicationBuildVersionNumber = this.getAppBuildNumber();
            int databaseBuildVersionNumber = this.getDbBuildNumber();
            if (databaseBuildVersionNumber > applicationBuildVersionNumber) {
                if (this.jiraSystemProperties.getBoolean("jira.downgrade.allowed").booleanValue()) {
                    log.info("Database build number is: " + databaseBuildVersionNumber + ", Application build number is: " + applicationBuildVersionNumber);
                    log.info("Attempting a data downgrade because jira.downgrade.allowed is set to 'true'");
                    return this.attemptDowngrade();
                }
                log.debug("There is a data consistency error: Database build number is: " + databaseBuildVersionNumber + ", Application build number is: " + applicationBuildVersionNumber);
                this.setBuildNumberInconsistentMessages(this.canAttemptDowngrade());
                return false;
            }
            if (this.jiraSystemProperties.getBoolean("jira.downgrade.allowed").booleanValue()) {
                log.warn("System property jira.downgrade.allowed is set to 'true' but no downgrade is required. It is recommended to remove this setting unless you actually need to downgrade.");
            }
        }
        return true;
    }

    private boolean canAttemptDowngrade() {
        try {
            return this.buildDowngradeWorker().canDowngrade();
        }
        catch (DowngradeException ex) {
            log.error("Unexpected error in the Downgrade Task framework.", (Throwable)ex);
            return false;
        }
    }

    private DowngradeWorker buildDowngradeWorker() {
        DbConnectionManagerImpl dbConnectionManager = new DbConnectionManagerImpl(this.databaseConfigurationManager, (DelegatorInterface)CoreFactory.getGenericDelegator());
        DefaultOfBizDelegator ofBizDelegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return new DowngradeWorker(this.buildUtilsInfo, dbConnectionManager, ofBizDelegator, applicationProperties, this.upgradeVersionHistoryManager);
    }

    private void setBuildNumberInconsistentMessages(boolean canAttemptDowngrade) {
        this.buildFaultDescriptions("Failed to start JIRA due to a build number inconsistency.", "The data present in your database is newer than the version of JIRA you are trying to startup.\nDatabase build number: " + this.getDbBuildNumber() + "\nJIRA app build number: " + this.getAppBuildNumber(), "Please use the correct version of JIRA. You are running: " + this.buildUtilsInfo.getBuildInformation());
        if (canAttemptDowngrade) {
            this.faultDescription = this.faultDescription + "Alternatively, you can allow a Downgrade to occur by setting the system property jira.downgrade.allowed=true.\n";
        }
    }

    private boolean attemptDowngrade() {
        DowngradeWorker downgradeWorker = this.buildDowngradeWorker();
        try {
            downgradeWorker.downgrade(DowngradeWorker.Mode.START_UP);
            downgradeWorker.writeNewBuildNumbers();
            return true;
        }
        catch (MissingDowngradeTaskException ex) {
            this.buildFaultDescriptions(ex.getMessage(), "Database build number: " + this.getDbBuildNumber(), "JIRA app build number: " + this.getAppBuildNumber(), "JIRA app version: " + this.buildUtilsInfo.getBuildInformation());
            return false;
        }
        catch (DowngradeException | RuntimeException ex) {
            this.buildFaultDescriptions("An unexpected error occured while trying to downgrade.", "Database build number: " + this.getDbBuildNumber(), "JIRA app build number: " + this.getAppBuildNumber(), "JIRA app version: " + this.buildUtilsInfo.getBuildInformation());
            this.htmlFaultDescription = this.htmlFaultDescription + "<p>See the log files for details</p>";
            this.faultDescription = this.faultDescription + "Error: " + ex.getMessage() + "\n";
            log.error("An unexpected error occured while trying to downgrade.", (Throwable)ex);
            return false;
        }
    }

    private void buildFaultDescriptions(String ... messages) {
        this.htmlFaultDescription = "";
        this.faultDescription = "";
        for (String message : messages) {
            this.faultDescription = this.faultDescription + message + "\n";
            this.htmlFaultDescription = this.htmlFaultDescription + "<p>" + message.replace("\n", "<br>") + "</p>";
        }
    }

    private boolean databaseSetup() {
        return UpgradeUtils.tableExists("project");
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.htmlFaultDescription;
    }

    @Override
    public String getFaultDescription() {
        return "\n\n" + StringUtils.repeat((String)"*", (int)100) + '\n' + this.faultDescription + StringUtils.repeat((String)"*", (int)100) + "\n";
    }

    private int getDbBuildNumber() {
        return this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    private int getAppBuildNumber() {
        return this.buildUtilsInfo.getApplicationBuildNumber();
    }

    public String toString() {
        return NAME;
    }
}

