/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.clustering;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.I18nHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIdCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(NodeIdCheck.class);
    static final String NAME = "JIRA Cluster Node ID Check";
    static final String FAULT_DESC = "startup.node.id.check";
    private final ClusterNodeProperties clusterNodeProperties;
    private final I18nHelper i18nHelper;

    public NodeIdCheck(ClusterNodeProperties clusterNodeProperties, I18nHelper i18nHelper) {
        this.clusterNodeProperties = clusterNodeProperties;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        log.debug("Performing JIRA Cluster Node ID Check");
        return StringUtils.isNotBlank((CharSequence)this.clusterNodeProperties.getNodeId());
    }

    @Override
    public String getFaultDescription() {
        return this.i18nHelper.getText(FAULT_DESC);
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.getFaultDescription();
    }
}

