/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ajsmeta;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.ajsmeta.DarkFeaturesMeta;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webfragment.conditions.SmtpMailServerConfiguredCondition;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.util.ProductVersionDataBean;
import com.atlassian.jira.web.util.ProductVersionDataBeanProvider;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;

@Internal
public final class HtmlMetadataManager {
    private final JiraWebResourceManager webResourceManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FeatureManager featureManager;
    private final ProductVersionDataBean productVersionDataBean;
    private final PermissionManager permissionManager;
    private final JiraProperties jiraSystemProperties;
    private final MailSettings mailSettings;

    public HtmlMetadataManager(JiraWebResourceManager webResourceManager, BuildUtilsInfo buildUtilsInfo, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, KeyboardShortcutManager keyboardShortcutManager, VelocityRequestContextFactory velocityRequestContextFactory, FeatureManager featureManager, ProductVersionDataBeanProvider productVersionDataBeanProvider, PermissionManager permissionManager, MailSettings mailSettings, JiraProperties jiraSystemProperties) {
        this.webResourceManager = webResourceManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
        this.jiraSystemProperties = jiraSystemProperties;
        this.productVersionDataBean = productVersionDataBeanProvider.get();
        this.mailSettings = mailSettings;
    }

    public void requireCommonMetadata() {
        if (this.jiraSystemProperties.getBoolean("atlassian.disable.issue.collector").booleanValue()) {
            this.webResourceManager.putMetadata("disable-issue-collector", "true");
        }
        ApplicationUser user = this.authenticationContext.getUser();
        this.webResourceManager.putMetadata("dev-mode", Boolean.toString(this.jiraSystemProperties.isDevMode()));
        this.webResourceManager.putMetadata("context-path", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
        this.webResourceManager.putMetadata("version-number", this.buildUtilsInfo.getVersion());
        this.webResourceManager.putMetadata("build-number", this.buildUtilsInfo.getCurrentBuildNumber());
        this.webResourceManager.putMetadata("is-beta", Boolean.toString(this.buildUtilsInfo.isBeta()));
        this.webResourceManager.putMetadata("is-rc", Boolean.toString(this.buildUtilsInfo.isRc()));
        this.webResourceManager.putMetadata("is-snapshot", Boolean.toString(this.buildUtilsInfo.isSnapshot()));
        this.webResourceManager.putMetadata("is-milestone", Boolean.toString(this.buildUtilsInfo.isMilestone()));
        this.webResourceManager.putMetadata("remote-user", user != null ? user.getName() : "");
        this.webResourceManager.putMetadata("remote-user-fullname", user != null ? user.getDisplayName() : "");
        this.webResourceManager.putMetadata("user-locale", this.authenticationContext.getLocale().toString());
        NumberFormat numberFormat = NumberFormat.getInstance(this.authenticationContext.getLocale());
        String groupingSeparator = "";
        if (numberFormat.isGroupingUsed() && numberFormat instanceof DecimalFormat) {
            groupingSeparator = "" + ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getGroupingSeparator();
        }
        this.webResourceManager.putMetadata("user-locale-group-separator", groupingSeparator);
        this.webResourceManager.putMetadata("app-title", this.getAppTitle());
        this.webResourceManager.putMetadata("keyboard-shortcuts-enabled", Boolean.toString(this.keyboardShortcutManager.isKeyboardShortcutsEnabled()));
        this.webResourceManager.putMetadata("keyboard-accesskey-modifier", BrowserUtils.getModifierKey());
        this.webResourceManager.putMetadata("enabled-dark-features", new DarkFeaturesMeta(this.featureManager).getContent());
        this.webResourceManager.putMetadata("in-admin-mode", Boolean.toString(ExecutingHttpRequest.get().getAttribute("jira.admin.mode") != null));
        this.webResourceManager.putMetadata("is-sysadmin", Boolean.toString(user != null ? this.permissionManager.hasPermission(44, user) : false));
        this.webResourceManager.putMetadata("is-admin", Boolean.toString(user != null ? this.permissionManager.hasPermission(0, user) : false));
        this.webResourceManager.putMetadata("outgoing-mail-enabled", Boolean.toString(SmtpMailServerConfiguredCondition.isOutgoingMailEnabled(this.mailSettings)));
        this.requireLookAndFeelDateFormatMetadata();
    }

    private void requireLookAndFeelDateFormatMetadata() {
        this.webResourceManager.putMetadata("date-relativize", this.applicationProperties.getDefaultBackedString("jira.lf.date.relativize"));
        this.webResourceManager.putMetadata("date-time", this.applicationProperties.getDefaultBackedString("jira.lf.date.time"));
        this.webResourceManager.putMetadata("date-day", this.applicationProperties.getDefaultBackedString("jira.lf.date.day"));
        this.webResourceManager.putMetadata("date-dmy", this.applicationProperties.getDefaultBackedString("jira.lf.date.dmy"));
        this.webResourceManager.putMetadata("date-complete", this.applicationProperties.getDefaultBackedString("jira.lf.date.complete"));
    }

    public void includeMetadata(Writer writer) throws IOException {
        Map metadata = this.webResourceManager.getMetadata();
        for (Map.Entry metaDataEntry : metadata.entrySet()) {
            this.writeTo(writer, (String)metaDataEntry.getKey(), (String)metaDataEntry.getValue());
        }
    }

    private void writeTo(Writer writer, String key, String value) throws IOException {
        writer.write("<meta name=\"ajs-");
        writer.write(TextUtils.htmlEncode((String)key));
        writer.write("\" content=\"");
        writer.write(TextUtils.htmlEncode((String)value));
        writer.write("\">\n");
    }

    private String getAppTitle() {
        return this.applicationProperties.getDefaultBackedString("jira.title");
    }

    public ProductVersionDataBean getVersionBean() {
        return this.productVersionDataBean;
    }
}

