/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.admin.ApplicationPropertiesPersister;
import com.atlassian.jira.admin.PropertyDescriptions;
import com.atlassian.jira.admin.RenderablePropertyFactory;
import com.atlassian.jira.admin.RenderablePropertyImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.velocity.JiraVelocityManager;

public class AnnouncementBanner {
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory i18nFactory;
    private final RenderablePropertyImpl property;

    public AnnouncementBanner(JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, RendererManager rendererManager, JiraVelocityManager jiraVelocityManager, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nFactory, RenderablePropertyFactory renderablePropertyFactory) {
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.i18nFactory = i18nFactory;
        this.property = renderablePropertyFactory.create(new ApplicationPropertiesPersister(applicationProperties, "jira.alertheader"), new AnnouncementBannerDescriptions());
    }

    public boolean isDisplay() {
        return StringUtils.isNotBlank((String)this.property.getValue()) && (this.headerIsPublic() || this.jiraAuthenticationContext.isLoggedInUser());
    }

    public String getViewHtml() {
        return this.property.getValue();
    }

    public String getEditHtml() {
        return this.property.getEditHtml("announcement");
    }

    public String getIntroHtml() {
        return this.getText("admin.announcement.description");
    }

    protected boolean headerIsPublic() {
        return "public".equals(this.applicationProperties.getDefaultBackedString("jira.alertheader.visibility"));
    }

    private String getText(String key) {
        return this.i18nFactory.getInstance(this.jiraAuthenticationContext.getUser()).getText(key);
    }

    private class AnnouncementBannerDescriptions
    implements PropertyDescriptions {
        private AnnouncementBannerDescriptions() {
        }

        @Override
        public String getBtfDescriptionHtml() {
            return AnnouncementBanner.this.getText("admin.announcement.close.tags");
        }

        @Override
        public String getOnDemandDescriptionHtml() {
            return AnnouncementBanner.this.getText("admin.announcement.help.text");
        }
    }
}

