/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.memoryinspector.MemoryInspector;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.util.ValueStack;

public class ManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(ManagerFactory.class);

    public static synchronized void globalRefresh() {
        log.debug("ManagerFactory.globalRefresh");
        ManagerFactory.getIndexLifecycleManager().shutdown();
        TaskManager taskManager = ComponentManager.getInstance().getTaskManager();
        taskManager.shutdownAndWait(0L);
        ((ClusterServicesManager)ComponentAccessor.getComponent(ClusterServicesManager.class)).stopServices();
        ComponentManager.getInstance().stop();
        ComponentManager.getInstance().dispose();
        MultiThreadedHttpConnectionManager.shutdownAll();
        new MemoryInspector().inspectMemoryAfterJiraShutdown();
        ComponentManager.getInstance().initialise();
        ValueStack.clearMethods();
        ComponentManager.getInstance().start();
        ComponentManager.getInstance().lateStart();
        CoreFactory.globalRefresh();
        ManagerFactory.getConstantsManager().refresh();
    }

    private ManagerFactory() {
    }

    private static ConstantsManager getConstantsManager() {
        return (ConstantsManager)ManagerFactory.getContainer().getComponent(ConstantsManager.class);
    }

    private static IndexLifecycleManager getIndexLifecycleManager() {
        return ComponentManager.getInstance().getIndexLifecycleManager();
    }

    private static PicoContainer getContainer() {
        return ComponentManager.getInstance().getContainer();
    }
}

