/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.startup.JiraStartupPluginSystemListener;

public enum ComponentManagerStateImpl implements ComponentManager.State
{
    NOT_STARTED(0, false, false, false, false, false, "startup.page.state.NOT_STARTED"),
    CONTAINER_INITIALISED(5, true, false, false, false, false, "startup.page.state.CONTAINER_INITIALISED"){

        @Override
        public String getMessageKey() {
            return this.isStillInBootstrapContainer() ? NOT_STARTED.getMessageKey() : super.getMessageKey();
        }

        @Override
        public int getPercentage() {
            if (this.isStillInBootstrapContainer()) {
                return 0;
            }
            int min = super.getPercentage();
            int max = PLUGINSYSTEM_STARTED.getPercentage();
            return min + JiraStartupPluginSystemListener.getProgress(max - min);
        }

        private boolean isStillInBootstrapContainer() {
            return !ComponentManager.ContainerLevel.FULL_CONTAINER.equals((Object)ComponentManager.getInstance().getContainerLevel());
        }
    }
    ,
    PLUGINSYSTEM_STARTED(95, true, false, true, false, false, "startup.page.state.PLUGINSYSTEM_STARTED"),
    COMPONENTS_REGISTERED(97, true, true, true, false, false, "startup.page.state.COMPONENTS_REGISTERED"),
    COMPONENTS_INSTANTIATED(98, true, true, true, true, false, "startup.page.state.COMPONENTS_INSTANTIATED"),
    STARTED(100, true, true, true, true, true, "startup.page.state.STARTED");

    private final int percentage;
    private final boolean componentsRegistered;
    private final boolean pluginSystemStarted;
    private final boolean started;
    private final boolean containerInitialised;
    private final boolean componentsInstantiated;
    private final String messageKey;

    private ComponentManagerStateImpl(int percentage, boolean containerInitialised, boolean componentsRegistered, boolean pluginSystemStarted, boolean componentsInstantiated, boolean started, String messageKey) {
        this.percentage = percentage;
        this.containerInitialised = containerInitialised;
        this.componentsRegistered = componentsRegistered;
        this.pluginSystemStarted = pluginSystemStarted;
        this.componentsInstantiated = componentsInstantiated;
        this.started = started;
        this.messageKey = messageKey;
    }

    @Override
    public boolean isComponentsInstantiated() {
        return this.componentsInstantiated;
    }

    @Override
    public boolean isComponentsRegistered() {
        return this.componentsRegistered;
    }

    @Override
    public boolean isPluginSystemStarted() {
        return this.pluginSystemStarted;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isContainerInitialised() {
        return this.containerInitialised;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public int getPercentage() {
        return this.percentage;
    }
}

