/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.BootstrapContainerRegistrar;
import com.atlassian.jira.CacheManagerRegistrar;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.ComponentManagerStateImpl;
import com.atlassian.jira.ContainerRegistrar;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.FailedStartupContainerRegistrar;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.SetupContainerRegistrar;
import com.atlassian.jira.WrappedComponentContainer;
import com.atlassian.jira.application.install.ApplicationInstallListener;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.webwork.WebworkClassLoaderSupplier;
import com.atlassian.jira.diagnostic.PluginDiagnostics;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.extension.ContainerProvider;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.OsgiServiceTrackerCache;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.NotificationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.type.TypeFactory;
import org.joda.time.DateTime;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ComponentManager
implements Shutdown {
    public static final String EXTENSION_PROVIDER_PROPERTY = "jira.extension.container.provider";
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    private static final ComponentManager COMPONENT_MANAGER = new ComponentManager();
    private final PluginSystem pluginSystem = new PluginSystem();
    private volatile WrappedComponentContainer container;
    private volatile ContainerLevel containerLevel = null;
    private volatile ComponentManagerStateImpl state = ComponentManagerStateImpl.NOT_STARTED;

    private ComponentManager() {
    }

    public void bootstrapInitialise() {
        this.initComponentContainer(true, ContainerLevel.BOOTSTRAP);
        new BootstrapContainerRegistrar().registerComponents(this.container.getComponentContainer());
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    public void setupInitialise() {
        this.validateExtendBootstrapContainer("Setup Container");
        new SetupContainerRegistrar().registerComponents(this.container.getComponentContainer());
        this.setLevelToExtendedBootstrap();
    }

    public void extendBootstrapContainerForFailedStartup() {
        if (this.containerLevel == ContainerLevel.EXTENDED_BOOTSTRAP) {
            return;
        }
        this.validateExtendBootstrapContainer("Setup Container");
        new FailedStartupContainerRegistrar().registerComponents(this.container.getComponentContainer());
        this.setLevelToExtendedBootstrap();
    }

    private void setLevelToExtendedBootstrap() {
        this.eagerlyInstantiate();
        this.containerLevel = ContainerLevel.EXTENDED_BOOTSTRAP;
    }

    private void validateExtendBootstrapContainer(String containerName) {
        if (this.container == null) {
            throw new IllegalStateException("The bootstrap container has not been initialised, you cannot initialise a " + containerName);
        }
        if (this.containerLevel != ContainerLevel.BOOTSTRAP) {
            throw new IllegalStateException("You are only allowed to extend the Bootstrap Container, but we are currently at level " + (Object)((Object)this.containerLevel));
        }
        if (!this.state.isContainerInitialised()) {
            throw new IllegalStateException("The ComponentManager is " + this.state.name() + " so you cannot initialise a " + containerName);
        }
    }

    @VisibleForTesting
    void initialise(boolean useEagerInitialization) {
        this.registerComponents(useEagerInitialization);
        this.registerExtensions();
        this.runInitializingComponents();
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    public void initialise() {
        this.initialise(true);
    }

    public synchronized void start() {
        this.quickStart();
    }

    public synchronized void lateStart() {
        this.pluginSystem.lateStartup();
    }

    private void quickStart() {
        TypeFactory.instance.constructType(HashMap.class, (TypeBindings)null);
        ComponentManager.getComponent(PluginDiagnostics.class);
        Optional.ofNullable(ComponentManager.getComponent(ApplicationInstallListener.class)).ifPresent(ApplicationInstallListener::register);
        this.pluginSystem.earlyStartup();
        this.changeState(ComponentManagerStateImpl.PLUGINSYSTEM_STARTED);
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        List funNewComponents = pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentModuleDescriptor.class);
        if (!funNewComponents.isEmpty()) {
            for (ComponentModuleDescriptor componentModuleDescriptor : funNewComponents) {
                componentModuleDescriptor.registerComponents(this.container.getPicoContainer());
            }
        }
        ComponentManager.getComponent(WebworkClassLoaderSupplier.class).set(pluginAccessor.getClassLoader());
        this.container.getPicoContainer().addComponent((Object)pluginAccessor.getClassLoader());
        this.changeState(ComponentManagerStateImpl.COMPONENTS_REGISTERED);
        this.eagerlyInstantiate();
        this.changeState(ComponentManagerStateImpl.COMPONENTS_INSTANTIATED);
        this.runStartable();
        this.registerEventComponents();
        this.changeState(ComponentManagerStateImpl.STARTED);
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerStartedEvent.INSTANCE);
    }

    private void initComponentContainer(boolean useEagerInitialization, ContainerLevel newContainerLevel) {
        String name;
        if (this.container != null) {
            throw new IllegalStateException("Component container is already initialized");
        }
        switch (newContainerLevel) {
            case FULL_CONTAINER: {
                name = "JIRAContainer";
                break;
            }
            case BOOTSTRAP: {
                name = "BootstrapContainer";
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot init to ContainerLevel " + (Object)((Object)newContainerLevel));
            }
        }
        this.container = new WrappedComponentContainer(new ComponentContainer(useEagerInitialization));
        this.container.getPicoContainer().setName(name + '_' + DateTime.now());
        this.containerLevel = newContainerLevel;
    }

    public boolean componentsAvailable() {
        if (this.getContainerLevel() == ContainerLevel.FULL_CONTAINER) {
            return this.getState().isComponentsInstantiated();
        }
        return this.getContainerLevel() == ContainerLevel.EXTENDED_BOOTSTRAP;
    }

    private void registerEventComponents() {
        EventPublisher eventPublisher = ComponentManager.getComponent(EventPublisher.class);
        Set registeredListeners = Sets.newIdentityHashSet();
        Collection componentAdapters = this.getContainer().getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            Object instance;
            Class componentKey = componentAdapter.getComponentImplementation();
            if (componentKey.getAnnotation(EventComponent.class) == null || !registeredListeners.add(instance = componentAdapter.getComponentInstance((PicoContainer)this.container.getPicoContainer(), ComponentAdapter.NOTHING.class))) continue;
            eventPublisher.register(instance);
        }
    }

    private void runInitializingComponents() {
        Set seen = Sets.newIdentityHashSet();
        List components = this.getContainer().getComponents(InitializingComponent.class);
        for (InitializingComponent component : components) {
            try {
                if (!seen.add(component)) continue;
                component.afterInstantiation();
            }
            catch (Exception e) {
                log.error("Error occurred while initializing component '" + component.getClass().getName() + "'.", (Throwable)e);
                throw new InfrastructureException("Error occurred while initializing component '" + component.getClass().getName() + "'.", e);
            }
        }
    }

    private void runStartable() {
        Set seen = Sets.newIdentityHashSet();
        List startables = this.getContainer().getComponents(Startable.class);
        for (Startable startable : startables) {
            try {
                if (!seen.add(startable) || startable instanceof PluginSystemLifecycle) continue;
                startable.start();
            }
            catch (Exception e) {
                log.error("Error occurred while starting component '" + startable.getClass().getName() + "'.", (Throwable)e);
                throw new InfrastructureException("Error occurred while starting component '" + startable.getClass().getName() + "'.", e);
            }
        }
    }

    public synchronized void stop() {
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerShutdownEvent.INSTANCE);
        this.pluginSystem.shutdown();
    }

    public void dispose() {
        PropertyUtils.clearDescriptors();
        this.changeState(ComponentManagerStateImpl.NOT_STARTED);
        if (this.container != null) {
            CacheManagerRegistrar.shutDownCacheManager(this.container.getComponentContainer(), ManagementFactory.getPlatformMBeanServer());
            this.container.dispose();
            this.container = null;
            this.containerLevel = null;
        }
        ComponentManager.gc();
    }

    public void shutdown() {
        this.stop();
        this.dispose();
    }

    private static void gc() {
        int count = 0;
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (count < 10 && ref.get() != null) {
            log.debug("Attempting to do a garbage collection:" + ++count);
            System.gc();
        }
    }

    public State getState() {
        return this.state;
    }

    public PluginSystemState getPluginSystemState() {
        return this.pluginSystem.state;
    }

    ContainerLevel getContainerLevel() {
        return this.containerLevel;
    }

    @GuardedBy(value="this")
    private void eagerlyInstantiate() {
        this.container.getComponentContainer().initializeEagerComponents();
    }

    private void registerExtensions() {
        ApplicationProperties applicationProperties = this.container.getComponentContainer().getComponentInstance(ApplicationProperties.class);
        String extensionClassName = applicationProperties.getDefaultBackedString(EXTENSION_PROVIDER_PROPERTY);
        try {
            if (!StringUtils.isBlank((String)extensionClassName)) {
                this.container.wrapWith((ContainerProvider)ClassLoaderUtils.loadClass((String)extensionClassName, this.getClass()).newInstance());
            }
        }
        catch (Exception extensionClassLoadingException) {
            throw new RuntimeException(String.format("Error loading PICO extension provider container class with name '%s'", extensionClassName), extensionClassLoadingException);
        }
    }

    public PicoContainer getContainer() {
        WrappedComponentContainer container = this.container;
        return container != null ? container.getPicoContainer() : null;
    }

    public MutablePicoContainer getMutablePicoContainer() {
        WrappedComponentContainer container = this.container;
        return container != null ? container.getPicoContainer() : null;
    }

    private void registerComponents(boolean useEagerInitialization) {
        this.initComponentContainer(useEagerInitialization, ContainerLevel.FULL_CONTAINER);
        new ContainerRegistrar().registerComponents(this.container.getComponentContainer(), JiraStartupChecklist.startupOK());
    }

    private ComponentManagerStateImpl changeState(ComponentManagerStateImpl newState) {
        ComponentManagerStateImpl currentState = this.state;
        if (newState != ComponentManagerStateImpl.NOT_STARTED && newState.ordinal() != currentState.ordinal() + 1) {
            throw new IllegalStateException(String.format("Cannot change ComponentManager status from %s to %s", currentState, newState));
        }
        this.state = newState;
        return currentState;
    }

    public static ComponentManager getInstance() {
        return COMPONENT_MANAGER;
    }

    public static <T> T getComponentInstanceOfType(Class<T> clazz) {
        T component = ComponentManager.getComponent(clazz);
        if (component != null) {
            return component;
        }
        component = clazz.cast(ComponentManager.getInstance().getContainer().getComponent(clazz));
        if (component != null) {
            if (log.isDebugEnabled()) {
                try {
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException ex) {
                    log.warn("Unable to find component with key '" + clazz + "' - eventually found '" + component + "' the slow way.", (Throwable)ex);
                }
            } else {
                log.warn("Unable to find component with key '" + clazz + "' - eventually found '" + component + "' the slow way.");
            }
        }
        return component;
    }

    public static <T> T getComponent(Class<T> clazz) {
        ComponentManager componentManager = ComponentManager.getInstance();
        if (componentManager == null) {
            return null;
        }
        PicoContainer picoContainer = componentManager.getContainer();
        return (T)(picoContainer == null ? null : picoContainer.getComponent(clazz));
    }

    @Nullable
    public static <T> T getOSGiComponentInstanceOfType(Class<T> clazz) {
        Assertions.notNull((String)"class", clazz);
        OsgiServiceTrackerCache osgiServiceTrackerCache = ComponentManager.getComponent(OsgiServiceTrackerCache.class);
        if (osgiServiceTrackerCache != null) {
            return osgiServiceTrackerCache.getOsgiComponentOfType(clazz);
        }
        throw new IllegalStateException();
    }

    public static <T> List<T> getComponentsOfType(Class<T> clazz) {
        PicoContainer pico = ComponentManager.getInstance().getContainer();
        List adapters = pico.getComponentAdapters(clazz);
        if (adapters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> returnList = new ArrayList<T>(adapters.size());
        for (ComponentAdapter adapter : adapters) {
            returnList.add(clazz.cast(adapter.getComponentInstance(pico)));
        }
        return Collections.unmodifiableList(returnList);
    }

    public static <T> Map<String, T> getComponentsOfTypeMap(Class<T> iface) {
        PicoContainer picoContainer = ComponentManager.getInstance().getContainer();
        List componentAdaptersOfType = picoContainer.getComponentAdapters(iface);
        HashMap<String, T> implementations = new HashMap<String, T>();
        for (ComponentAdapter componentAdapter : componentAdaptersOfType) {
            T componentInstance = iface.cast(componentAdapter.getComponentInstance(picoContainer));
            implementations.put(String.valueOf(componentAdapter.getComponentKey()), componentInstance);
        }
        return Collections.unmodifiableMap(implementations);
    }

    private PluginAccessor getPluginAccessor() {
        return (PluginAccessor)this.getContainer().getComponent(PluginAccessor.class);
    }

    IndexLifecycleManager getIndexLifecycleManager() {
        return (IndexLifecycleManager)this.getContainer().getComponent(IndexLifecycleManager.class);
    }

    TaskManager getTaskManager() {
        return (TaskManager)this.getContainer().getComponent(TaskManager.class);
    }

    static enum ContainerLevel {
        BOOTSTRAP,
        EXTENDED_BOOTSTRAP,
        FULL_CONTAINER;

    }

    public static interface State {
        public boolean isContainerInitialised();

        public boolean isPluginSystemStarted();

        public boolean isComponentsRegistered();

        public boolean isComponentsInstantiated();

        public boolean isStarted();

        public String getMessageKey();

        public int getPercentage();
    }

    private static class PluginSystem {
        volatile PluginSystemState state = PluginSystemState.NOT_STARTED;

        private PluginSystem() {
        }

        void earlyStartup() {
            if (this.state != PluginSystemState.NOT_STARTED) {
                return;
            }
            try {
                ((SplitStartupPluginSystemLifecycle)ComponentAccessor.getComponent(SplitStartupPluginSystemLifecycle.class)).earlyStartup();
                this.state = PluginSystemState.EARLY_STARTED;
            }
            catch (NotificationException ex) {
                Throwable cause = ex.getCause();
                throw new InfrastructureException("Error occurred while starting Plugin Manager. " + cause.getMessage(), cause);
            }
            catch (Exception e) {
                throw new InfrastructureException("Error occurred while starting Plugin Manager. " + e.getMessage(), e);
            }
        }

        void lateStartup() {
            if (this.state != PluginSystemState.EARLY_STARTED) {
                return;
            }
            this.state = PluginSystemState.LATE_STARTED;
            ((SplitStartupPluginSystemLifecycle)ComponentAccessor.getComponent(SplitStartupPluginSystemLifecycle.class)).lateStartup();
        }

        public void shutdown() {
            if (this.state == PluginSystemState.NOT_STARTED) {
                return;
            }
            try {
                ((PluginSystemLifecycle)ComponentAccessor.getComponent(PluginSystemLifecycle.class)).shutdown();
            }
            catch (RuntimeException ignore) {
                log.error("Error occurred while shutting down the component manager.", (Throwable)ignore);
            }
            this.state = PluginSystemState.NOT_STARTED;
        }
    }

    public static enum PluginSystemState {
        NOT_STARTED,
        EARLY_STARTED,
        LATE_STARTED;

    }
}

