/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.application.api.ApplicationManager;
import com.atlassian.jira.config.component.PicoContainerFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.parameters.ComponentParameter;

class ComponentContainer {
    private final MutablePicoContainer container = PicoContainerFactory.defaultJIRAContainer();
    private final Registry registry = new Registry();
    private final boolean initializeComponentsEagerly;

    public ComponentContainer() {
        this(false);
    }

    public ComponentContainer(boolean eagerInitialization) {
        this.initializeComponentsEagerly = eagerInitialization;
    }

    MutablePicoContainer getPicoContainer() {
        return this.container;
    }

    ComponentAdapter getComponentAdapter(Class<?> key) {
        return this.container.getComponentAdapter(key);
    }

    <T> T getComponentInstance(Class<T> key) {
        return (T)this.container.getComponent(key);
    }

    HostComponentProvider getHostComponentProvider() {
        return new HostComponentProviderImpl(this.registry);
    }

    void instance(Scope scope, Object instance) {
        scope.get(this.registry).register(instance.getClass());
        this.container.addComponent(instance);
    }

    void instance(Scope scope, String key, Object instance) {
        scope.get(this.registry).register(instance.getClass());
        this.container.addComponent((Object)key, instance, new Parameter[0]);
    }

    <T, S extends T> void instance(Scope scope, Class<T> key, S instance) {
        scope.get(this.registry).register(key);
        this.container.addComponent(key, instance, new Parameter[0]);
    }

    void implementation(Scope scope, Class<?> implementation) {
        scope.get(this.registry).register(implementation);
        this.container.addComponent(implementation);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation) {
        scope.get(this.registry).register(key);
        this.container.addComponent(key, implementation, new Parameter[0]);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation, Object ... parameterKeys) {
        Parameter[] componentParameters = new Parameter[parameterKeys.length];
        for (int i = 0; i < parameterKeys.length; ++i) {
            Object parameter = parameterKeys[i];
            componentParameters[i] = parameter instanceof Parameter ? (Parameter)parameter : new ComponentParameter(parameter);
        }
        this.implementation(scope, key, implementation, componentParameters);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation, Parameter[] parameters) {
        scope.get(this.registry).register(key);
        this.container.addComponent(key, implementation, parameters);
    }

    <T> void implementationUseDefaultConstructor(Scope scope, Class<T> key, Class<? extends T> implementation) {
        scope.get(this.registry).register(key);
        this.container.addComponent(key, implementation, new Parameter[0]);
    }

    <T> void provideViaFactory(Class<? super T> serviceInterface, Class<? extends ServiceFactory<T>> osgiFactoryClass) {
        this.registry.registerOsgiFactory(serviceInterface, osgiFactoryClass);
    }

    void component(Scope scope, ComponentAdapter componentAdapter) {
        scope.get(this.registry).register(componentAdapter);
        this.container.addAdapter(componentAdapter);
    }

    void initializeEagerComponents() {
        if (this.initializeComponentsEagerly) {
            this.container.getComponents();
        }
    }

    static String extractSpringLikeBeanNameFromInterface(Set<String> usedKeys, Class<?> clazz) {
        Assertions.notNull((String)"clazz", clazz);
        String hardCodedKey = ComponentContainer.mapDuplicates(clazz);
        if (hardCodedKey != null) {
            return hardCodedKey;
        }
        String className = clazz.getSimpleName();
        String calculatedKey = className.substring(0, 1).toLowerCase(Locale.ENGLISH) + className.substring(1);
        if (usedKeys.contains(calculatedKey)) {
            throw new IllegalStateException("Duplicate component key found for '" + calculatedKey + "'.");
        }
        return calculatedKey;
    }

    private static String mapDuplicates(Class<?> clazz) {
        if (clazz.equals(ApplicationProperties.class)) {
            return "salApplicationProperties";
        }
        if (clazz.equals(I18nHelper.class)) {
            return "contextI18nHelper";
        }
        if (clazz.equals(ApplicationManager.class)) {
            return "atlassianApplicationManager";
        }
        return null;
    }

    private static final class Component {
        private final Object instance;
        private final Set<Class<?>> interfaces;

        Component(Object instance, Set<Class<?>> interfaces) {
            this.instance = Assertions.notNull((String)"instance", (Object)instance);
            this.interfaces = Collections.unmodifiableSet(new HashSet((Collection)Assertions.notNull((String)"interfaces", interfaces)));
        }

        public Object getInstance() {
            return this.instance;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces.toArray(new Class[this.interfaces.size()]);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Component && this.instance == ((Component)obj).instance;
        }
    }

    private class Registry {
        private final Set<Class<?>> availableComponents = new HashSet();
        private final Map<Class<?>, Class<?>> factoryRegistrations = new HashMap();

        private Registry() {
        }

        private void validateInterface(Class<?> interfaceClass) {
            if (!interfaceClass.isInterface()) {
                throw new IllegalArgumentException(interfaceClass + " must be an interface to provide to plugins.");
            }
            if (this.availableComponents.contains(interfaceClass) || this.factoryRegistrations.containsKey(interfaceClass)) {
                throw new IllegalArgumentException(interfaceClass + " has already been provided.");
            }
        }

        void register(Class<?> componentKey) {
            this.validateInterface(componentKey);
            this.availableComponents.add(componentKey);
        }

        void register(ComponentAdapter componentAdapter) {
            Object key = componentAdapter.getComponentKey();
            if (key instanceof Class) {
                this.register((Class)key);
            }
        }

        <T> void registerOsgiFactory(Class<? super T> serviceInterface, Class<? extends ServiceFactory<T>> osgiFactoryClass) {
            this.validateInterface(serviceInterface);
            this.factoryRegistrations.put(serviceInterface, osgiFactoryClass);
        }

        Set<Component> getComponents() {
            MultiMap instances = MultiMaps.create((Supplier)new Supplier<Set<Class<?>>>(){

                public Set<Class<?>> get() {
                    return new HashSet();
                }
            });
            for (Class<?> clazz : this.availableComponents) {
                Object instance = ComponentContainer.this.getComponentInstance(clazz);
                if (instance == null) continue;
                instances.putSingle(instance, clazz);
            }
            for (Map.Entry entry : this.factoryRegistrations.entrySet()) {
                Class exposedInterface = (Class)entry.getKey();
                Class factoryClass = (Class)entry.getValue();
                Object instance = JiraUtils.loadComponent(factoryClass);
                if (instance != null) {
                    instances.putSingle(instance, (Object)exposedInterface);
                    continue;
                }
                throw new IllegalStateException(exposedInterface + " can not be provided to plugins: " + factoryClass + " can not be instantiated.");
            }
            HashSet<Component> result = new HashSet<Component>();
            for (Map.Entry entry : instances.entrySet()) {
                result.add(new Component(entry.getKey(), (Set)entry.getValue()));
            }
            return Collections.unmodifiableSet(result);
        }
    }

    static class HostComponentProviderImpl
    implements HostComponentProvider {
        private final Registry registry;

        HostComponentProviderImpl(Registry registry) {
            this.registry = registry;
        }

        public void provide(ComponentRegistrar registrar) {
            Set<Component> components = this.registry.getComponents();
            HashSet<String> usedKeys = new HashSet<String>();
            for (Component component : components) {
                Class<?>[] interfaces;
                for (Class<?> iface : interfaces = component.getInterfaces()) {
                    String name = ComponentContainer.extractSpringLikeBeanNameFromInterface(usedKeys, iface);
                    registrar.register(new Class[]{iface}).forInstance(component.getInstance()).withName(name);
                    usedKeys.add(name);
                }
            }
        }
    }

    static enum Scope {
        PROVIDED{

            @Override
            Registrar get(final Registry registry) {
                return new Registrar(){

                    @Override
                    public void register(Class<?> klass) {
                        registry.register(klass);
                    }

                    @Override
                    public void register(ComponentAdapter adapter) {
                        registry.register(adapter);
                    }
                };
            }
        }
        ,
        INTERNAL{

            @Override
            Registrar get(Registry registry) {
                return new Registrar(){

                    @Override
                    public void register(Class<?> klass) {
                    }

                    @Override
                    public void register(ComponentAdapter adapter) {
                    }
                };
            }
        };


        abstract Registrar get(Registry var1);

        static interface Registrar {
            public void register(Class<?> var1);

            public void register(ComponentAdapter var1);
        }
    }
}

