/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.velocity.CachingJiraClassMap;
import com.atlassian.velocity.JiraClassMap;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.IntrospectorCache;

@TenantInfo(value=TenantAware.TENANTLESS, comment="Purely a local class/method resolution concern")
@ClusterSafe
public class JiraIntrospectorCache
implements IntrospectorCache {
    private static final String NO_EXPIRY_PROPERTY = "atlassian.cache.velocity.noexpiry";
    private final LoadingCache<Class<?>, ClassMap> classMapCache;

    public JiraIntrospectorCache(Log log) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (!JiraSystemProperties.getInstance().getBoolean(NO_EXPIRY_PROPERTY).booleanValue()) {
            builder.expireAfterAccess(30L, TimeUnit.MINUTES);
        }
        this.classMapCache = builder.build(new CacheLoader<Class<?>, ClassMap>(){

            public ClassMap load(@Nonnull Class<?> key) throws Exception {
                return new CachingJiraClassMap(new JiraClassMap(key));
            }
        });
    }

    public void clear() {
        this.classMapCache.invalidateAll();
    }

    public ClassMap get(Class clazz) {
        return (ClassMap)this.classMapCache.getUnchecked((Object)clazz);
    }

    public ClassMap put(Class clazz) {
        return (ClassMap)this.classMapCache.getUnchecked((Object)clazz);
    }
}

