/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.fugue.Option;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.velocity.JiraClassMap;
import com.atlassian.velocity.VelocityTypesUtil;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.MethodMap;

public class CachingJiraClassMap
implements ClassMap {
    @TenantInfo(value=TenantAware.TENANTLESS, comment="Not being transformed to VCache JVMCache as this acts like a registry, not a cache")
    private final ConcurrentMap<MethodCacheEntry, Option<Method>> methodCache = new ConcurrentHashMap<MethodCacheEntry, Option<Method>>();
    private final JiraClassMap delegate;

    public CachingJiraClassMap(JiraClassMap delegate) {
        this.delegate = delegate;
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        MethodCacheEntry cacheKey = this.getCacheKey(name, params);
        Option cachedMethod = (Option)this.methodCache.get(cacheKey);
        if (cachedMethod != null) {
            return (Method)cachedMethod.getOrNull();
        }
        Method resolvedMethod = this.delegate.findMethod(name, params);
        Option<Method> prevValue = this.methodCache.putIfAbsent(cacheKey, (Option<Method>)Option.option((Object)resolvedMethod));
        return prevValue != null ? (Method)prevValue.getOrNull() : resolvedMethod;
    }

    private MethodCacheEntry getCacheKey(String name, Object[] params) {
        return new MethodCacheEntry(name, params);
    }

    @VisibleForTesting
    static class MethodCacheEntry {
        private final String methodName;
        private final Class<?>[] paramsTypes;

        private MethodCacheEntry(String methodName, Object[] params) {
            this.methodName = methodName;
            this.paramsTypes = VelocityTypesUtil.getParametersTypes(params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCacheEntry that = (MethodCacheEntry)o;
            if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
                return false;
            }
            return Arrays.equals(this.paramsTypes, that.paramsTypes);
        }

        public int hashCode() {
            int result = this.methodName != null ? this.methodName.hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.paramsTypes);
            return result;
        }
    }
}

