/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.workflow.WorkflowDescriptorXmlUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.JiraWorkflowDTO;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="It must be resolved when we remove the switching request cache dependency")
@EventComponent
public class CachingWorkflowDescriptorStore
implements WorkflowDescriptorStore {
    private static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.CachingWorkflowDescriptorStore.caches.request";
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<String, Optional<ImmutableWorkflowDescriptor>> workflowCache;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<String[]> allNamesCache;
    private final WorkflowDescriptorStore delegate;

    public CachingWorkflowDescriptorStore(WorkflowDescriptorStore delegate, SwitchingCacheFactory cacheFactory) {
        this.delegate = delegate;
        this.workflowCache = cacheFactory.buildSwitchingRequestCache(CachingWorkflowDescriptorStore.class.getName() + ".workflowCache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.allNamesCache = cacheFactory.buildSwitchingRequestCache(CachingWorkflowDescriptorStore.class.getName() + ".allNamesCache", delegate::getWorkflowNames, DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.workflowCache.removeAll();
        this.allNamesCache.reset();
    }

    @EventListener
    public void onWorkflowDescriptorXmlUpdatedEvent(WorkflowDescriptorXmlUpdatedEvent event) {
        this.removeWorkflowFromCache(event.getWorkflowName());
    }

    @Override
    public ImmutableWorkflowDescriptor getWorkflow(@Nonnull String name) throws FactoryException {
        Assertions.notNull((String)"Workflow name", (Object)name);
        return ((Optional)this.workflowCache.get(name, () -> this.loadWorkflowDescriptor(name))).orElse(null);
    }

    @Override
    public boolean removeWorkflow(@Nonnull String name) {
        boolean deleted;
        Assertions.notNull((String)"Workflow name", (Object)name);
        try {
            deleted = this.delegate.removeWorkflow(name);
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorkflow(@Nonnull String name, @Nonnull WorkflowDescriptor workflowDescriptor, boolean replace) throws DataAccessException {
        Assertions.notNull((String)"Workflow name", (Object)name);
        Assertions.notNull((String)"workflowDescriptor", (Object)workflowDescriptor);
        try {
            boolean bl = this.delegate.saveWorkflow(name, workflowDescriptor, replace);
            return bl;
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
    }

    @Override
    public String[] getWorkflowNames() {
        String[] names = this.allNamesCache.get();
        return Arrays.copyOf(names, names.length);
    }

    @Override
    public List<JiraWorkflowDTO> getAllJiraWorkflowDTOs() {
        return this.delegate.getAllJiraWorkflowDTOs();
    }

    private void removeWorkflowFromCache(String name) {
        this.workflowCache.remove(name);
        this.allNamesCache.reset();
    }

    private Optional<ImmutableWorkflowDescriptor> loadWorkflowDescriptor(@Nonnull String name) {
        try {
            return Optional.ofNullable(this.delegate.getWorkflow(name));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

