/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.task;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.web.util.CloudControlIPCheck;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.scheduler.core.RunningJob;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.TENANTLESS)
public class TaskQuiescingServlet
extends HttpServlet {
    public static final int SC_UNCANCELABLE_TASKS_STILL_RUNNING = 500;
    public static final int SC_TASKS_STILL_RUNNING = 503;
    public static final String DISABLE_QUEUES = "disableQueues";
    public static final String CANCEL_TASKS = "cancelTasks";
    private static final Logger log = LoggerFactory.getLogger(TaskQuiescingServlet.class);
    private static final JsonFactory JSON = new MappingJsonFactory();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseObject responseJson = this.validateIsCloudAndFromControlIp(request);
        if (responseJson.getStatus() != 200) {
            this.respond(response, responseJson);
            return;
        }
        Optional optionalTaskManager = ComponentAccessor.getComponentSafely(TaskManager.class);
        Optional optionalScheduler = ComponentAccessor.getComponentSafely(LifecycleAwareSchedulerService.class);
        if (!optionalTaskManager.isPresent() || !optionalScheduler.isPresent()) {
            responseJson.setStatus(500);
            responseJson.addMessage("Task manager or scheduler are not available");
            this.respond(response, responseJson);
            return;
        }
        responseJson.setStatus(200);
        this.addTasksToResponse(responseJson, (TaskManager)optionalTaskManager.get(), (LifecycleAwareSchedulerService)optionalScheduler.get());
        this.respond(response, responseJson);
    }

    private void addTasksToResponse(ResponseObject responseJson, TaskManager taskManager, LifecycleAwareSchedulerService scheduler) {
        responseJson.setBackgroundTasks(this.serializeBackgroundTasks(taskManager.getLiveTasks()));
        responseJson.setScheduledJobs(this.serializeScheduledJobs(scheduler.getLocallyRunningJobs()));
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseObject responseJson = this.validateIsCloudAndFromControlIp(request);
        if (responseJson.getStatus() != 200) {
            this.respond(response, responseJson);
            return;
        }
        String path = request.getPathInfo();
        if (path == null) {
            responseJson = this.quiesce(request);
        } else if (path.equals("/resume")) {
            responseJson = this.resume();
        } else {
            responseJson.setStatus(400);
            responseJson.addMessage("Unknown path " + path);
        }
        this.respond(response, responseJson);
    }

    private ResponseObject quiesce(HttpServletRequest request) throws IOException {
        Optional<String> optionalAction = this.getCancelTasksParameter(request);
        if (!optionalAction.isPresent()) {
            ResponseObject responseJson = new ResponseObject();
            responseJson.setStatus(400);
            responseJson.addMessage("Missing action parameter");
            return responseJson;
        }
        String action = optionalAction.get();
        Optional optionalTaskManager = ComponentAccessor.getComponentSafely(TaskManager.class);
        Optional optionalScheduler = ComponentAccessor.getComponentSafely(LifecycleAwareSchedulerService.class);
        if (!optionalTaskManager.isPresent()) {
            ResponseObject responseJson = new ResponseObject();
            responseJson.setStatus(500);
            responseJson.addMessage("TaskManager is not available.");
            return responseJson;
        }
        if (!optionalScheduler.isPresent()) {
            ResponseObject responseJson = new ResponseObject();
            responseJson.setStatus(500);
            responseJson.addMessage("Scheduler is not available.");
            return responseJson;
        }
        LifecycleAwareSchedulerService scheduler = (LifecycleAwareSchedulerService)optionalScheduler.get();
        TaskManager taskManager = (TaskManager)optionalTaskManager.get();
        ResponseObject responseJson = action == CANCEL_TASKS ? this.cancelTasks(taskManager, scheduler) : this.stopQueues(taskManager, scheduler);
        ComponentAccessor.getComponentSafely(MailQueue.class).ifPresent(mq -> mq.sendBuffer());
        return responseJson;
    }

    private ResponseObject resume() throws ServletException, IOException {
        ResponseObject responseJson = new ResponseObject();
        Optional optionalTaskManager = ComponentAccessor.getComponentSafely(TaskManager.class);
        Optional optionalScheduler = ComponentAccessor.getComponentSafely(LifecycleAwareSchedulerService.class);
        if (optionalTaskManager.isPresent()) {
            ((TaskManager)optionalTaskManager.get()).start();
            responseJson.addMessage("TaskManager successfully restarted");
        } else {
            responseJson.setStatus(500);
            responseJson.addMessage("TaskManager is not available; it cannot be restarted.");
        }
        if (optionalScheduler.isPresent()) {
            try {
                ((LifecycleAwareSchedulerService)optionalScheduler.get()).start();
                responseJson.addMessage("SchedulerService successfully restarted");
            }
            catch (SchedulerServiceException e) {
                responseJson.setStatus(500);
                log.error(e.toString());
                responseJson.addMessage("An error occurred while restarting Scheduler: " + e.getMessage());
            }
        } else {
            responseJson.setStatus(500);
            responseJson.addMessage("SchedulerService is not available; it cannot be restarted");
        }
        responseJson.setStatusIfNotAlreadySet(200);
        return responseJson;
    }

    private boolean areUpgradeJobsRunning() {
        Optional optionalUpgradeManager = ComponentAccessor.getComponentSafely(UpgradeManager.class);
        if (optionalUpgradeManager.isPresent()) {
            UpgradeManager upgrades = (UpgradeManager)optionalUpgradeManager.get();
            return upgrades.areDelayedUpgradesRunning();
        }
        return false;
    }

    private boolean areNonCancelableTasksRunning(TaskManager taskManager) {
        return taskManager.getLiveTasks().stream().anyMatch(task -> !task.isCancellable());
    }

    private ResponseObject stopQueues(TaskManager taskManager, LifecycleAwareSchedulerService scheduler) {
        ResponseObject responseJson = new ResponseObject();
        if (this.areUpgradeJobsRunning()) {
            responseJson.setStatus(500);
            responseJson.addMessage("There delayed upgrade tasks running");
            return responseJson;
        }
        if (this.areNonCancelableTasksRunning(taskManager)) {
            responseJson.setStatus(500);
            responseJson.addMessage("There are non cancelable tasks running");
            return responseJson;
        }
        try {
            taskManager.shutdownAndWait(0L, TimeUnit.SECONDS);
            scheduler.standby();
            responseJson.setStatus(200);
        }
        catch (SchedulerServiceException e) {
            responseJson.setStatus(500);
            responseJson.addMessage("Could not put Scheduler in standby mode");
            log.error("There was an error shutting putting LifecycleAwareSchedulerService in standby mode: " + e.getMessage());
            log.debug(e.toString());
        }
        this.addTasksToResponse(responseJson, taskManager, scheduler);
        return responseJson;
    }

    private ResponseObject cancelTasks(TaskManager taskManager, LifecycleAwareSchedulerService scheduler) {
        ResponseObject responseJson = this.stopQueues(taskManager, scheduler);
        if (responseJson.getStatus() != 200) {
            return responseJson;
        }
        Collection<TaskDescriptor<?>> runningTasks = taskManager.getLiveTasks();
        Collection runningJobs = scheduler.getLocallyRunningJobs();
        if (!runningTasks.isEmpty()) {
            for (TaskDescriptor<Object> taskDescriptor : runningTasks) {
                if (taskDescriptor.isCancellable()) {
                    taskManager.cancelTask(taskDescriptor.getTaskId());
                    log.info("Sending cancel to task: " + taskDescriptor.getTaskId() + " " + taskDescriptor.getDescription());
                    continue;
                }
                responseJson.setStatus(500);
                log.warn("Task: " + taskDescriptor.getTaskId() + " " + taskDescriptor.getDescription() + " is not cancelable");
            }
            if (responseJson.getStatus() != 500) {
                responseJson.setStatus(503);
            }
        }
        if (!runningJobs.isEmpty()) {
            for (RunningJob runningJob : runningJobs) {
                runningJob.cancel();
                log.info("Sending cancel to job: " + runningJob.getJobId() + " " + runningJob.getJobConfig().getJobRunnerKey() + "");
            }
            if (responseJson.getStatus() != 500) {
                responseJson.setStatus(503);
            }
        }
        this.addTasksToResponse(responseJson, taskManager, scheduler);
        responseJson.setStatusIfNotAlreadySet(200);
        return responseJson;
    }

    private void respond(HttpServletResponse response, ResponseObject responseJson) throws IOException {
        int status = responseJson.getStatus();
        response.setStatus(status);
        response.setContentType("application/json");
        if (status == 200 || status == 503 || status == 500 || status == 400) {
            try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((Writer)response.getWriter());){
                jsonGenerator.writeObject((Object)responseJson);
            }
        }
    }

    private List<Map<String, Serializable>> serializeScheduledJobs(Collection<RunningJob> runningJobs) {
        List<Map<String, Serializable>> serializableRunningJobs = runningJobs.stream().map(job -> ImmutableMap.of((Object)"jobID", (Object)job.getJobId().toString(), (Object)"startTime", (Object)job.getStartTime(), (Object)"config", (Object)job.getJobConfig().toString())).collect(Collectors.toList());
        return serializableRunningJobs;
    }

    private List<Map<String, Serializable>> serializeBackgroundTasks(Collection<TaskDescriptor<?>> backgroundTasks) {
        List<Map<String, Serializable>> serializableTasks = backgroundTasks.stream().map(task -> ImmutableMap.builder().put((Object)"description", (Object)task.getDescription()).put((Object)"isStarted", (Object)task.isStarted()).put((Object)"isCancelable", (Object)task.isCancellable()).put((Object)"isCanceled", (Object)task.isCancelled()).put((Object)"taskID", (Object)task.getTaskId()).put((Object)"progressURL", (Object)task.getProgressURL()).put((Object)"elapsedRuntime", (Object)String.valueOf(task.getElapsedRunTime())).put((Object)"submittedTimestamp", (Object)task.getSubmittedTimestamp()).build()).collect(Collectors.toList());
        return serializableTasks;
    }

    private Optional<String> getCancelTasksParameter(HttpServletRequest request) throws NumberFormatException {
        String cancelParam = request.getParameter("action");
        if (CANCEL_TASKS.equalsIgnoreCase(cancelParam)) {
            return Optional.of(CANCEL_TASKS);
        }
        if (DISABLE_QUEUES.equalsIgnoreCase(cancelParam)) {
            return Optional.of(DISABLE_QUEUES);
        }
        log.warn("Expected action parameter to be one of {}, {}, but was {}", new Object[]{CANCEL_TASKS, DISABLE_QUEUES, cancelParam});
        return Optional.empty();
    }

    private ResponseObject validateIsCloudAndFromControlIp(HttpServletRequest request) {
        ResponseObject responseJson = new ResponseObject();
        CloudControlIPCheck isCloudAndControl = new CloudControlIPCheck();
        if (isCloudAndControl.test(request)) {
            responseJson.setStatus(200);
        } else {
            String ipAddress = request.getHeader("X-FORWARDED-FOR");
            if (ipAddress == null) {
                ipAddress = request.getRemoteAddr();
            }
            log.warn("Attempted to access " + request.getRequestURL() + " from: " + ipAddress);
            responseJson.setStatus(403);
        }
        return responseJson;
    }

    private static class ResponseObject
    implements Serializable {
        private static int UNSET_STATUS = -1;
        private final AtomicInteger statusCode = new AtomicInteger(UNSET_STATUS);
        @JsonProperty
        private final ConcurrentLinkedQueue<String> messages = new ConcurrentLinkedQueue();
        @JsonProperty
        private volatile List<Map<String, Serializable>> backgroundTasks = Lists.newArrayList();
        @JsonProperty
        private volatile List<Map<String, Serializable>> scheduledTasks = Lists.newArrayList();

        public int getStatus() {
            return this.statusCode.get();
        }

        public void setStatus(int statusCode) {
            this.statusCode.set(statusCode);
        }

        public void setStatusIfNotAlreadySet(int statusCode) {
            this.statusCode.compareAndSet(UNSET_STATUS, statusCode);
        }

        public Collection<String> getMessages() {
            return ImmutableList.copyOf(this.messages);
        }

        public void addMessage(String message) {
            this.messages.add(message);
        }

        public void setBackgroundTasks(List<Map<String, Serializable>> backgroundTasks) {
            this.backgroundTasks = backgroundTasks;
        }

        public void setScheduledJobs(List<Map<String, Serializable>> schedulerTasks) {
            this.scheduledTasks = schedulerTasks;
        }
    }
}

