/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.i18n.BootstrapJiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class TextTag
extends WebWorkBodyTagSupport
implements ParamTag.UnnamedParametric {
    private static final Logger log = LoggerFactory.getLogger(TextTag.class);
    private String nameAttr;
    private String value0Attr;
    private String value1Attr;
    private String value2Attr;
    private String value3Attr;
    private ArrayList<Object> values;
    private static final boolean HIGHLIGHT = JiraSystemProperties.getInstance().getBoolean("jira.i18n.texthighlight");

    public void setName(String aName) {
        this.nameAttr = aName;
    }

    public void setValue0(String aName) {
        this.value0Attr = aName;
    }

    public void setValue1(String aName) {
        this.value1Attr = aName;
    }

    public void setValue2(String aName) {
        this.value2Attr = aName;
    }

    public void setValue3(String aName) {
        this.value3Attr = aName;
    }

    public void addParameter(String aName, Object aValue) {
        this.addParameter(aValue);
    }

    public void addParameter(Object aValue) {
        if (aValue == null) {
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(aValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        try {
            this.addAttributeProperties();
            String msgKey = this.determineMsgKey(this.nameAttr);
            if (StringUtils.isNotBlank((String)msgKey)) {
                Object[] substitutionValues = this.values == null ? new String[]{} : this.values.toArray();
                String formattedText = TextTag.getI18nHelper().getText(msgKey, (Object)substitutionValues);
                this.safelyWrite(formattedText, msgKey);
            } else {
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
                log.info("An empty i18n key was provided in " + httpServletRequest.getRequestURI());
            }
            int n = 6;
            return n;
        }
        finally {
            this.clearTagState();
        }
    }

    private void addAttributeProperties() {
        if (this.value0Attr != null) {
            this.addParameter(this.findValue(this.value0Attr));
        }
        if (this.value1Attr != null) {
            this.addParameter(this.findValue(this.value1Attr));
        }
        if (this.value2Attr != null) {
            this.addParameter(this.findValue(this.value2Attr));
        }
        if (this.value3Attr != null) {
            this.addParameter(this.findValue(this.value3Attr));
        }
    }

    private String determineMsgKey(String nameAttr) {
        String msgKey;
        try {
            msgKey = this.findString(nameAttr);
            if (msgKey == null) {
                msgKey = nameAttr;
            }
        }
        catch (Exception e) {
            msgKey = nameAttr;
        }
        return msgKey;
    }

    private void clearTagState() {
        this.value3Attr = null;
        this.value2Attr = null;
        this.value1Attr = null;
        this.value0Attr = null;
        this.nameAttr = null;
        this.values = null;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getComponentSafely(JiraAuthenticationContext.class).orElseGet(BootstrapJiraAuthenticationContext::new).getI18nHelper();
    }

    private void safelyWrite(String formattedText, String msgKey) throws JspException {
        try {
            this.write(formattedText, msgKey);
        }
        catch (IOException rootCause) {
            throw new JspException((Throwable)rootCause);
        }
    }

    private void write(String string, String msgKey) throws IOException {
        JspWriter jspWriter = this.pageContext.getOut();
        if (HIGHLIGHT) {
            jspWriter.write("<span class='replaced' data-i18n='" + msgKey + "'>");
            jspWriter.write(string);
            jspWriter.write("</span>");
        } else {
            jspWriter.write(string);
        }
    }
}

