/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ComponentManagerStateImpl;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.Johnson;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;

public class StartupServlet
extends HttpServlet {
    static final String ACCEPT = "Accept";
    static final String APPLICATION_JSON = "application/json";
    static final String TEXT_HTML = "text/html";
    static final String CHARSET_UTF_8 = ";charset=UTF-8";
    static final JsonFactory JSON = new MappingJsonFactory();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (APPLICATION_JSON.equals(request.getHeader(ACCEPT))) {
            this.respondWithJson(request, response);
        } else if (this.hasJohnsonEvents(request) || this.getCurrentState().isStarted()) {
            StartupPageSupport.returnFromStartupJsp(request, response);
        } else {
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(503);
            this.includeStartupJsp(request, response);
        }
    }

    private void respondWithJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.hasJohnsonEvents(request)) {
            response.setStatus(500);
            response.getWriter().flush();
        } else {
            ComponentManager.State state = this.getCurrentState();
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            this.writeJson(request, response, state);
        }
    }

    @VisibleForTesting
    protected void writeJson(HttpServletRequest request, HttpServletResponse response, ComponentManager.State state) throws IOException {
        try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
            jsonGenerator.writeObject((Object)ImmutableMap.of((Object)"progress", (Object)ImmutableMap.of((Object)"message", (Object)StartupPageSupport.getTranslator(request).apply(state.getMessageKey()), (Object)"percentage", (Object)state.getPercentage()), (Object)"state", (Object)state));
        }
    }

    @VisibleForTesting
    protected ComponentManager.State getCurrentState() {
        ComponentManager.State state = ComponentManager.getInstance().getState();
        if (state.isStarted() && !StartupPageSupport.isLaunched()) {
            return ComponentManagerStateImpl.COMPONENTS_REGISTERED;
        }
        return state;
    }

    @VisibleForTesting
    protected boolean hasJohnsonEvents(HttpServletRequest request) {
        return Johnson.getEventContainer((ServletContext)request.getServletContext()).hasEvents();
    }

    @VisibleForTesting
    protected void includeStartupJsp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("/startup.jsp").include((ServletRequest)request, (ServletResponse)response);
    }
}

