/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.startup;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.startup.InstantUpgradeManager;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;

public class InstantUpgradeServlet
extends HttpServlet {
    static final JsonFactory JSON = new MappingJsonFactory();
    static final String INSTANCE_STATE = "state";
    static final String MESSAGE = "message";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImmutableMap responseJson;
        Optional maybeInstantUpgradeManager = ComponentAccessor.getComponentSafely(InstantUpgradeManager.class);
        response.setContentType("application/json");
        if (!maybeInstantUpgradeManager.isPresent()) {
            responseJson = ImmutableMap.of((Object)MESSAGE, (Object)"instant upgrade manager is not available");
            response.setStatus(503);
        } else {
            responseJson = ImmutableMap.of((Object)INSTANCE_STATE, (Object)((InstantUpgradeManager)maybeInstantUpgradeManager.get()).getState().name());
            response.setStatus(200);
        }
        try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((Writer)response.getWriter());){
            jsonGenerator.writeObject((Object)responseJson);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Optional<Object> responseJson;
        response.setContentType("application/json");
        Optional maybeInstantUpgradeManager = ComponentAccessor.getComponentSafely(InstantUpgradeManager.class);
        if (!maybeInstantUpgradeManager.isPresent()) {
            responseJson = Optional.of(ImmutableMap.of((Object)MESSAGE, (Object)"instant upgrade manager is not available"));
            response.setStatus(503);
        } else {
            ServiceResult activateInstanceResult = ((InstantUpgradeManager)maybeInstantUpgradeManager.get()).activateInstance();
            if (activateInstanceResult.isValid()) {
                response.setStatus(200);
                responseJson = Optional.empty();
            } else {
                responseJson = Optional.of(ImmutableMap.of((Object)MESSAGE, (Object)activateInstanceResult.getErrorCollection().getErrorMessages()));
                response.setStatus(500);
            }
        }
        if (responseJson.isPresent()) {
            try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((Writer)response.getWriter());){
                jsonGenerator.writeObject(responseJson.get());
            }
        }
    }
}

