/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.plugin.icon.IconTypeDefinitionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.servlet.AvatarToStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewUniversalAvatarServletImpl {
    public static final String AVATAR_ID_PARAM = "avatarId";
    public static final String AVATAR_TYPE_PARAM = "avatarType";
    public static final String AVATAR_SIZE_PARAM = "size";
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarToStream avatarToStream;
    private final IconTypeDefinitionFactory iconTypeFactory;
    private final AvatarManager avatarManager;

    public ViewUniversalAvatarServletImpl(JiraAuthenticationContext authenticationContext, AvatarToStream avatarToStream, IconTypeDefinitionFactory iconTypeFactory, AvatarManager avatarManager) {
        this.authenticationContext = authenticationContext;
        this.avatarToStream = avatarToStream;
        this.iconTypeFactory = iconTypeFactory;
        this.avatarManager = avatarManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Avatar avatar = this.getAvatar(request);
            Avatar.Size size = this.getValidAvatarSize(request);
            this.avatarToStream.sendAvatar(avatar, size, request, response);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(404, iae.getMessage());
        }
    }

    @Nonnull
    private Avatar getAvatar(HttpServletRequest request) {
        ApplicationUser user = this.authenticationContext.getUser();
        long avatarId = this.getValidAvatarId(request);
        IconType iconType = this.getValidAvatarType(request);
        Avatar avatar = this.avatarManager.getById(Long.valueOf(avatarId));
        if (avatar != null) {
            if (!avatar.getIconType().equals((Object)iconType)) {
                throw new IllegalArgumentException("No icon with ID=" + avatarId + " for type=" + iconType);
            }
            boolean userCanViewAvatar = this.avatarManager.userCanView(user, avatar);
            if (!userCanViewAvatar) {
                avatar = null;
            }
        }
        if (null == avatar) {
            avatar = this.avatarManager.getDefaultAvatar(iconType);
        }
        return avatar;
    }

    private long getValidAvatarId(HttpServletRequest request) {
        String avatarIdSpec = request.getParameter(AVATAR_ID_PARAM);
        if (null == avatarIdSpec) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM);
        }
        try {
            return Long.valueOf(avatarIdSpec);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM, x);
        }
    }

    private IconType getValidAvatarType(HttpServletRequest request) {
        String avatarTypeSpec = request.getParameter(AVATAR_TYPE_PARAM);
        IconType iconType = IconType.of((String)avatarTypeSpec);
        if (null == iconType) {
            throw new IllegalArgumentException(AVATAR_TYPE_PARAM);
        }
        return iconType;
    }

    private Avatar.Size getValidAvatarSize(HttpServletRequest request) {
        String avatarSizeSpec = request.getParameter(AVATAR_SIZE_PARAM);
        if (null == avatarSizeSpec) {
            return Avatar.Size.defaultSize();
        }
        try {
            return Avatar.Size.getSizeFromParam((String)avatarSizeSpec);
        }
        catch (NoSuchElementException x) {
            throw new IllegalArgumentException(AVATAR_SIZE_PARAM, x);
        }
    }
}

