/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ViewProjectAvatarServlet
extends AbstractAvatarServlet {
    @Override
    protected Long validateInput(String projectId, Long avatarId, HttpServletResponse response) throws IOException {
        IconType iconType = IconType.PROJECT_ICON_TYPE;
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return null;
        }
        if (StringUtils.isBlank((String)projectId)) {
            return avatarManagerOptional.get().getDefaultAvatarId(iconType);
        }
        Optional<ProjectManager> projectManagerOptional = this.getProjectManager();
        if (!projectManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return null;
        }
        Project project = projectManagerOptional.get().getProjectObj(Long.valueOf(Long.parseLong(projectId)));
        if (project == null) {
            response.sendError(404, "Unknown project");
            return null;
        }
        if (!avatarManagerOptional.get().userCanView(this.getAuthenticationContext().getLoggedInUser(), project.getAvatar())) {
            response.sendError(403, "Unknown project");
            return null;
        }
        if (avatarId == null) {
            return project.getAvatar().getId();
        }
        return avatarId;
    }

    @Override
    protected String getOwnerIdParamName() {
        return "pid";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    Optional<ProjectManager> getProjectManager() {
        return ComponentAccessor.getComponentSafely(ProjectManager.class);
    }
}

