/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

public class RangeResponse {
    private final int startIndex;
    private final Integer endIndex;
    private final int totalFileLength;

    public RangeResponse(int startIndex, Integer endIndex, int totalFileLength) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.totalFileLength = totalFileLength;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public int calculateContentLength() {
        if (this.endIndex == null) {
            return this.totalFileLength - this.startIndex;
        }
        return this.endIndex - this.startIndex + 1;
    }

    public String calculateContentRange() {
        int end = this.endIndex == null ? this.totalFileLength - 1 : this.endIndex;
        return "bytes " + this.startIndex + "-" + end + "/" + this.totalFileLength;
    }

    public String toString() {
        return this.calculateContentRange();
    }
}

