/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.landingpage;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.license.RenaissanceMigrationStatus;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.landingpage.LandingPageRedirectManager;
import com.atlassian.jira.web.landingpage.PageRedirect;
import java.util.Optional;

@EventComponent
public class RenaissanceMigrationPageRedirect
implements PageRedirect,
Startable {
    public static final String PROPERTY_POST_MIGRATION_PAGE_DISPLAYED = "post.migration.page.displayed";
    private static final String URL = "/secure/MigrationSummary.jspa";
    private static final int REDIRECT_PRIORITY = 1;
    private final ApplicationProperties properties;
    private final LandingPageRedirectManager landingPageRedirectManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final RenaissanceMigrationStatus renaissanceMigrationStatus;

    public RenaissanceMigrationPageRedirect(ApplicationProperties properties, LandingPageRedirectManager landingPageRedirectManager, GlobalPermissionManager globalPermissionManager, RenaissanceMigrationStatus renaissanceMigrationStatus) {
        this.properties = properties;
        this.landingPageRedirectManager = landingPageRedirectManager;
        this.globalPermissionManager = globalPermissionManager;
        this.renaissanceMigrationStatus = renaissanceMigrationStatus;
    }

    @Override
    public Optional<String> url(ApplicationUser user) {
        return this.shouldDisplaySummary() && user != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) ? Optional.of(URL) : Optional.empty();
    }

    private boolean shouldDisplaySummary() {
        return this.renaissanceMigrationStatus.hasMigrationRun() && !this.wasPageDisplayed();
    }

    private boolean wasPageDisplayed() {
        return this.properties.getOption(PROPERTY_POST_MIGRATION_PAGE_DISPLAYED);
    }

    public void start() {
        if (!this.wasPageDisplayed()) {
            this.landingPageRedirectManager.registerRedirect(this, 1);
        }
    }

    @EventListener
    public void onImportCompletedEvent(ImportCompletedEvent event) {
        this.start();
    }

    public void unregisterSelf() {
        this.landingPageRedirectManager.unregisterRedirect(this);
    }
}

