/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.gzip;

import com.atlassian.gzipfilter.GzipFilter;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import com.atlassian.jira.component.ComponentAccessor;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraGzipFilter
extends GzipFilter {
    private static final Logger log = LoggerFactory.getLogger(JiraGzipFilter.class);
    private static final String ALREADY_FILTERED = GzipFilter.class.getName() + "_already_filtered";

    public JiraGzipFilter() {
        super((GzipFilterIntegration)new JiraGzipFilterIntegration());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute("javax.servlet.error.request_uri") != null && req.getAttribute(ALREADY_FILTERED) != null) {
            req.setAttribute(ALREADY_FILTERED, null);
        }
        super.doFilter(req, res, chain);
    }

    private static class JiraGzipFilterIntegration
    implements GzipFilterIntegration {
        private JiraGzipFilterIntegration() {
        }

        public boolean useGzip() {
            try {
                return ComponentAccessor.getApplicationProperties().getOption("jira.option.web.usegzip");
            }
            catch (RuntimeException e) {
                log.debug("Cannot get application properties, defaulting to no GZip compression");
                return false;
            }
        }

        public String getResponseEncoding(HttpServletRequest httpServletRequest) {
            return ComponentAccessor.getApplicationProperties().getEncoding();
        }
    }
}

