/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean.i18n;

import com.atlassian.jira.web.bean.i18n.TranslationStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;

public abstract class TranslationStoreTemplate<K, V>
implements TranslationStore {
    private final ImmutableMap<K, V> map;

    public TranslationStoreTemplate(Map<String, String> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put(this.makeKeyFromString(entry.getKey()), this.makeValueFromString(entry.getValue()));
        }
        this.map = builder.build();
    }

    @Override
    public String get(String key) {
        Object value = this.map.get(this.makeKeyFromString(key));
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(this.makeKeyFromString(key));
    }

    @Override
    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new KeysIterator();
            }
        };
    }

    protected abstract K makeKeyFromString(String var1);

    protected abstract V makeValueFromString(String var1);

    private class KeysIterator
    implements Iterator<String> {
        private final UnmodifiableIterator<K> it;

        private KeysIterator() {
            this.it = TranslationStoreTemplate.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public String next() {
            Object next = this.it.next();
            return next != null ? next.toString() : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

