/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.diff.CharacterChunk;
import com.atlassian.diff.DiffChunk;
import com.atlassian.diff.DiffType;
import com.atlassian.diff.DiffViewBean;
import com.atlassian.diff.WordChunk;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffViewRenderer {
    private static final Integer MAX_WHITESPACE_PRESERVATION_LENGTH = 20;
    private static final Logger log = LoggerFactory.getLogger(DiffViewRenderer.class);

    static Integer getMaxWhitespacePreservationLength() {
        return MAX_WHITESPACE_PRESERVATION_LENGTH;
    }

    public String getUnifiedHtml(DiffViewBean wordLevelDiff) {
        return this.getUnifiedHtml(wordLevelDiff, null, null);
    }

    public String getUnifiedHtml(DiffViewBean wordLevelDiff, String removedStyle, String addedStyle) {
        Assertions.notNull((String)"wordLevelDiff", (Object)wordLevelDiff);
        return this.renderHtml(wordLevelDiff.getUnifiedChunks(), removedStyle, addedStyle);
    }

    public String getOriginalHtml(DiffViewBean wordLevelDiff) {
        return this.getOriginalHtml(wordLevelDiff, null, null);
    }

    public String getOriginalHtml(DiffViewBean wordLevelDiff, String removedStyle, String addedStyle) {
        Assertions.notNull((String)"wordLevelDiff", (Object)wordLevelDiff);
        return this.renderHtml(wordLevelDiff.getOriginalChunks(), removedStyle, addedStyle);
    }

    public String getRevisedHtml(DiffViewBean wordLevelDiff) {
        return this.getRevisedHtml(wordLevelDiff, null, null);
    }

    public String getRevisedHtml(DiffViewBean wordLevelDiff, String removedStyle, String addedStyle) {
        Assertions.notNull((String)"wordLevelDiff", (Object)wordLevelDiff);
        return this.renderHtml(wordLevelDiff.getRevisedChunks(), removedStyle, addedStyle);
    }

    private String renderHtml(List<DiffChunk> revisedChunks, String removedStyle, String addedStyle) {
        StringBuilder html = new StringBuilder();
        if (StringUtils.isEmpty((String)removedStyle)) {
            removedStyle = "background-color: #FFE0E0; font-weight: bold;";
        }
        if (StringUtils.isEmpty((String)addedStyle)) {
            addedStyle = "background-color: #E0FFE0; font-weight: bold;";
        }
        for (DiffChunk chunk : revisedChunks) {
            if (chunk.getType() == DiffType.CHANGED_WORDS) {
                WordChunk wordChunk = (WordChunk)chunk;
                for (CharacterChunk charChunk : wordChunk.getCharacterChunks()) {
                    html.append("<span class=\"").append(charChunk.getType().getClassName()).append("\"");
                    if (charChunk.getType() == DiffType.DELETED_CHARACTERS) {
                        html.append(" style=\"").append(removedStyle).append("\"");
                    } else if (charChunk.getType() == DiffType.ADDED_CHARACTERS) {
                        html.append(" style=\"").append(addedStyle).append("\"");
                    }
                    html.append(">");
                    html.append(DiffViewRenderer.print(charChunk.getText()));
                    html.append("</span>");
                }
            } else if (chunk.getType().getClassName().equals("unchanged")) {
                html.append(DiffViewRenderer.print(chunk.getText()));
            } else {
                html.append("<span class=\"").append(chunk.getType().getClassName()).append("\"");
                if (chunk.getType() == DiffType.DELETED_WORDS) {
                    html.append(" style=\"").append(removedStyle).append("\"");
                } else if (chunk.getType() == DiffType.ADDED_WORDS) {
                    html.append(" style=\"").append(addedStyle).append("\"");
                }
                html.append(">");
                html.append(DiffViewRenderer.print(chunk.getText()));
                html.append("</span>");
            }
            html.append("\n");
        }
        return html.toString();
    }

    private static String print(String s) {
        s = TextUtils.htmlEncode((String)s, (boolean)false);
        s = s.replaceAll("(\\r\\n|\\n|\\r)", "<br>");
        StringBuffer result = new StringBuffer();
        Matcher matcher = Pattern.compile("(\\s{2,})").matcher(s);
        while (matcher.find()) {
            String match = matcher.group(0);
            int length = match.length();
            String replacement = StringUtils.repeat((String)"&nbsp;", (int)Math.min(length, MAX_WHITESPACE_PRESERVATION_LENGTH)) + StringUtils.repeat((String)" ", (int)Math.max(0, length - MAX_WHITESPACE_PRESERVATION_LENGTH));
            matcher.appendReplacement(result, replacement);
        }
        return matcher.appendTail(result).toString();
    }
}

