/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import org.springframework.util.StringUtils;

public class ProjectDataProvider
implements WebResourceDataProvider {
    private final ProjectManager projectManager = this.getProjectManager();
    private static final String PROJECT_TYPE = "projectType";
    private static final String PROJECT_KEY = "projectKey";

    public Jsonable get() {
        return writer -> {
            try {
                this.getJsonData().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getJsonData() throws JSONException {
        Option<String> optionalProjectType;
        JSONObject values = new JSONObject();
        if (this.canAccessComponents() && (optionalProjectType = this.getProjectType()).isDefined()) {
            values.put(PROJECT_TYPE, optionalProjectType.get());
        }
        return values;
    }

    private Option<String> getProjectType() {
        String projectKey = (String)ExecutingHttpRequest.get().getAttribute(PROJECT_KEY);
        if (StringUtils.isEmpty((Object)projectKey)) {
            return Option.none();
        }
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            return Option.none();
        }
        return Option.option((Object)project.getProjectTypeKey().getKey());
    }

    private boolean canAccessComponents() {
        return this.projectManager != null;
    }

    private ProjectManager getProjectManager() {
        return ProjectDataProvider.getComponentOrNull(ProjectManager.class);
    }

    private static <T> T getComponentOrNull(Class<T> clazz) {
        Option componentOption = Option.option(ComponentAccessor.getComponentSafely(clazz).orElse(null));
        return (T)componentOption.getOrNull();
    }
}

