/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroup;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.IssueNavigatorActionParams;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.action.filter.FilterOperationsBean;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class SearchDescriptionEnabledAction
extends IssueActionSupport {
    protected final IssueSearcherManager issueSearcherManager;
    protected FieldValuesHolder fieldValuesHolder;
    protected PermissionManager permissionManager;
    private JiraAuthenticationContext authenticationContext;
    private SearchContext searchContext;
    private IssueNavigatorActionParams actionParams;
    private FavouritesService favouritesService;
    private FilterOperationsBean filterOperationsBean;
    private final SearchService searchService;

    public SearchDescriptionEnabledAction(IssueSearcherManager issueSearcherManager, SearchService searchService) {
        this.issueSearcherManager = issueSearcherManager;
        this.searchService = searchService;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.favouritesService = (FavouritesService)ComponentAccessor.getComponentOfType(FavouritesService.class);
    }

    public boolean isShown(SearcherGroup searcherGroup) {
        return searcherGroup.isShown(this.getLoggedInUser(), this.getSearchContext());
    }

    protected IssueNavigatorActionParams getActionParams() {
        if (this.actionParams == null) {
            this.actionParams = new IssueNavigatorActionParams(ActionContext.getParameters());
        }
        return this.actionParams;
    }

    protected Collection<IssueSearcher<?>> getSearchers() {
        return this.issueSearcherManager.getAllSearchers();
    }

    protected SearchContext getSearchContext() {
        if (this.getActionParams().isUpdateParamsRequired()) {
            String query = this.getActionParams().getFirstValueForKey("jql");
            if (query != null) {
                return this.getSeachContextFromQueryString(query);
            }
            return this.getActionParams().getSearchContext();
        }
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null) {
            return this.searchService.getSearchContext(this.authenticationContext.getUser(), searchRequest.getQuery());
        }
        if (this.searchContext == null) {
            this.searchContext = this.createSearchContext();
        }
        return this.searchContext;
    }

    private SearchContext getSeachContextFromQueryString(String query) {
        SearchService.ParseResult jqlQuery;
        if (StringUtils.isNotBlank((String)query) && (jqlQuery = this.searchService.parseQuery(this.getLoggedInUser(), query)).isValid()) {
            return this.searchService.getSearchContext(this.getLoggedInUser(), jqlQuery.getQuery());
        }
        return this.createSearchContext();
    }

    private SearchContext createSearchContext() {
        Collection visibleProjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getUser());
        if (visibleProjects != null && visibleProjects.size() == 1) {
            return new SearchContextImpl(null, EasyList.build((Object)((Project)visibleProjects.iterator().next()).getId()), null);
        }
        return new SearchContextImpl();
    }

    public boolean validateSearchFilterIsSavedFilter(SearchRequest searchRequest, String i18n) {
        if (searchRequest.getId() == null) {
            String name = searchRequest.getName();
            this.log.error((Object)("Tried to perform operation on unsaved filter with id:" + searchRequest.getId() + " and name: " + name));
            this.addErrorMessage(this.getText(i18n, name == null ? "" : name));
            return false;
        }
        return true;
    }

    public FilterOperationsBean getFilterOperationsBean() {
        if (this.filterOperationsBean == null) {
            this.filterOperationsBean = this.createFilterOperationsBean(this.getLoggedInUser());
        }
        return this.filterOperationsBean;
    }

    protected FilterOperationsBean createFilterOperationsBean(ApplicationUser user) {
        return FilterOperationsBean.create(this.getSearchRequest(), this.isFilterValid(), user, false);
    }

    @Deprecated
    public boolean isFilterValid() {
        SearchRequest searchRequest = this.getSearchRequest();
        return searchRequest == null || !this.searchService.validateQuery(this.getLoggedInUser(), searchRequest.getQuery(), searchRequest.getId()).hasAnyErrors();
    }
}

