/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.importer.project.AbstractProjectImportProgress;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportProgressTrackerUtil;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@WebSudoRequired
public class ProjectImportMappingProgress
extends AbstractProjectImportProgress<MappingResult> {
    private final TaskManager taskManager;

    public ProjectImportMappingProgress(TaskManager taskManager, TaskDescriptorBean.Factory factory, JiraPageBuilderService jiraPageBuilderService, ProjectImportProgressTrackerUtil projectImportProgressTrackerUtil) {
        super(taskManager, factory, jiraPageBuilderService, projectImportProgressTrackerUtil);
        this.taskManager = taskManager;
    }

    @Override
    protected boolean taskIsComplete() {
        return ProjectImportBean.getProjectImportBeanFromSession().getMappingResult() != null;
    }

    @Override
    protected String handleFinishedTask(TaskDescriptorBean<MappingResult> ourTask) throws ExecutionException, InterruptedException {
        MappingResult mappingResult = ourTask.getResult();
        if (mappingResult == null) {
            return this.getRedirect("ProjectImportSelectProject!errorFromProgress.jspa");
        }
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        this.taskManager.removeTask(beanFromSession.getTaskProgressInformation().getTaskId());
        beanFromSession.getTaskProgressInformation().setTaskId(null);
        beanFromSession.setMappingResult(mappingResult);
        ErrorCollection errorCollection = beanFromSession.getTaskProgressInformation().getErrorCollection();
        if (errorCollection != null && !errorCollection.hasAnyErrors()) {
            beanFromSession.getTaskProgressInformation().setErrorCollection(null);
        }
        return this.getRedirect(this.getRedirectOnComplete());
    }

    @Override
    protected String getSubmitUrl() {
        return "ProjectImportMappingProgress.jspa";
    }

    @Override
    @ActionViewData
    public List<Map<String, Object>> getProgressTrackerSteps() {
        return this.getProgressTrackerSteps(ProjectImportProgressTrackerUtil.Page.IMPORT_VALIDATION);
    }
}

