/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterDeletionWarningViewProvider;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.filters.AbstractAdministerFilter;
import org.apache.commons.lang.StringUtils;

public class DeleteSharedFilter
extends AbstractAdministerFilter {
    private static final int FILTERS_PER_PAGE = 20;
    private final SearchRequestService searchRequestService;
    private final FilterDeletionWarningViewProvider filterDeletionWarningViewProvider;

    public DeleteSharedFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, PermissionManager permissionManager, SearchRequestManager searchRequestManager, FilterDeletionWarningViewProvider filterDeletionWarningViewProvider) {
        super(issueSearcherManager, searchRequestService, searchService, permissionManager, searchRequestManager);
        this.searchRequestService = searchRequestService;
        this.filterDeletionWarningViewProvider = filterDeletionWarningViewProvider;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(this.getJiraServiceContext(this.getFilterId()), this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        this.repaginateIfNeeded();
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private void repaginateIfNeeded() {
        int newResultCount;
        int pagingOffset = StringUtils.isNotBlank((String)this.getPagingOffset()) ? Integer.parseInt(this.getPagingOffset()) - 1 : -1;
        int n = newResultCount = StringUtils.isNotBlank((String)this.getTotalResultCount()) ? Integer.parseInt(this.getTotalResultCount()) - 1 : -1;
        if (pagingOffset >= 0) {
            this.setTotalResultCount("" + newResultCount);
            if (newResultCount % 20 == 0) {
                this.setPagingOffset("" + pagingOffset);
            }
        }
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    public String getWarningHtml() {
        return this.filterDeletionWarningViewProvider.getWarningHtml(this.getFilter());
    }
}

