/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractAdministerFilter
extends SearchDescriptionEnabledAction {
    private SearchRequest filter;
    private Long filterId;
    private String searchName;
    private String searchOwnerUserName;
    private String sortColumn;
    private String sortAscending;
    private String pagingOffset;
    private String totalResultCount;
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionManager;
    private final SearchRequestManager searchRequestManager;

    public AbstractAdministerFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, PermissionManager permissionManager, SearchRequestManager searchRequestManager) {
        super(issueSearcherManager, searchService);
        this.searchRequestService = searchRequestService;
        this.permissionManager = permissionManager;
        this.searchRequestManager = searchRequestManager;
    }

    protected SearchRequest getFilter() {
        if (this.filter == null && this.getFilterId() != null) {
            JiraServiceContext ctx = this.getJiraServiceContext(this.getFilterId());
            this.filter = this.searchRequestService.getFilter(ctx, this.getFilterId());
        }
        return this.filter;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public String getFilterName() throws GenericEntityException {
        SearchRequest filter = this.getFilter();
        return filter == null ? null : filter.getName();
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getSearchOwnerUserName() {
        return this.searchOwnerUserName;
    }

    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.searchOwnerUserName = searchOwnerUserName;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public String getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(String sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getPagingOffset() {
        return this.pagingOffset;
    }

    public void setPagingOffset(String pagingOffset) {
        this.pagingOffset = pagingOffset;
    }

    public String getTotalResultCount() {
        return this.totalResultCount;
    }

    public void setTotalResultCount(String totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    protected JiraServiceContext getJiraServiceContext(Long filterId) {
        Object ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(this.searchRequestManager.getSearchRequestOwner(filterId)) : this.getJiraServiceContext();
        return ctx;
    }

    protected String buildReturnUri() {
        StringBuilder url = new StringBuilder(this.getReturnUrl());
        url.append("?atl_token=").append(JiraUrlCodec.encode((String)this.getXsrfToken(), (String)"UTF-8"));
        if (StringUtils.isNotBlank((String)this.getSearchName())) {
            url.append("&searchName=").append(JiraUrlCodec.encode((String)this.getSearchName(), (String)"UTF-8"));
        }
        if (StringUtils.isNotBlank((String)this.getSearchOwnerUserName())) {
            url.append("&searchOwnerUserName=").append(JiraUrlCodec.encode((String)this.getSearchOwnerUserName(), (String)"UTF-8"));
        }
        if (StringUtils.isNotBlank((String)this.getSortColumn())) {
            url.append("&sortColumn=").append(JiraUrlCodec.encode((String)this.getSortColumn(), (String)"UTF-8"));
            url.append("&sortAscending=").append(JiraUrlCodec.encode((String)this.getSortAscending(), (String)"UTF-8"));
            url.append("&pagingOffset=").append(JiraUrlCodec.encode((String)this.getPagingOffset(), (String)"UTF-8"));
            url.append("&totalResultCount=").append(JiraUrlCodec.encode((String)this.getTotalResultCount(), (String)"UTF-8"));
        }
        return url.toString();
    }
}

