/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@WebSudoRequired
public class TimeTrackingAdmin
extends JiraWebActionSupport {
    private static final Long SAMPLE_DURATION = 131400L;
    private final ApplicationProperties applicationProperties;
    private final FieldManager fieldManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final JiraAuthenticationContext authenticationContext;
    private final PluginAccessor pluginAccessor;
    private final ReindexMessageManager reindexMessageManager;
    private String hoursPerDay;
    private String daysPerWeek;
    private String timeTrackingFormat;
    private boolean legacyModeGetter;
    private boolean legacyModeSetter;
    private boolean isCopyComment;
    private DateUtils.Duration defaultUnit;

    public TimeTrackingAdmin(ApplicationProperties applicationProperties, FieldManager fieldManager, JiraDurationUtils jiraDurationUtils, JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor, ReindexMessageManager reindexMessageManager) {
        this.applicationProperties = applicationProperties;
        this.fieldManager = fieldManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.authenticationContext = authenticationContext;
        this.pluginAccessor = pluginAccessor;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.hoursPerDay = applicationProperties.getDefaultBackedString("jira.timetracking.hours.per.day");
        this.daysPerWeek = applicationProperties.getDefaultBackedString("jira.timetracking.days.per.week");
        this.timeTrackingFormat = applicationProperties.getDefaultBackedString("jira.timetracking.format");
        try {
            this.defaultUnit = DateUtils.Duration.valueOf((String)applicationProperties.getDefaultBackedString("jira.timetracking.default.unit"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.defaultUnit = DateUtils.Duration.MINUTE;
        }
    }

    public boolean isTimeTracking() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    public boolean isLogWorkModuleEnabled() {
        return this.pluginAccessor.isPluginModuleEnabled("com.atlassian.jira.plugin.system.issueoperations:log-work");
    }

    public boolean isIssueOperationsPluginEnabled() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.plugin.system.issueoperations");
    }

    public String doDefault() throws Exception {
        this.legacyModeSetter = false;
        this.legacyModeGetter = this.applicationProperties.getOption("jira.timetracking.estimates.legacy.behaviour");
        this.isCopyComment = this.applicationProperties.getOption("jira.timetracking.copy.comment.to.work.desc.on.transition");
        return "input";
    }

    @RequiresXsrfCheck
    public String doDeactivate() throws Exception {
        if (this.isTimeTracking()) {
            this.applicationProperties.setOption("jira.option.timetracking", false);
            this.fieldManager.refresh();
        }
        return this.getRedirect("TimeTrackingAdmin!default.jspa");
    }

    @RequiresXsrfCheck
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We ignore the return value of setScale on purpose. All we need to know is it it will trigger an exception.")
    public String doActivate() throws Exception {
        if (!this.isTimeTracking()) {
            try {
                BigDecimal hoursPerDay = new BigDecimal(this.getHoursPerDay());
                hoursPerDay.setScale(2, RoundingMode.UNNECESSARY);
                if (hoursPerDay.equals(BigDecimal.ZERO) || !hoursPerDay.abs().equals(hoursPerDay)) {
                    this.addError("hoursPerDay", this.getText("admin.globalsettings.timetracking.error.notpositive"));
                    return "error";
                }
                try {
                    hoursPerDay.multiply(BigDecimal.valueOf(60L)).intValueExact();
                }
                catch (ArithmeticException e) {
                    this.addError("hoursPerDay", this.getText("admin.globalsettings.timetracking.error.invalidhoursperday"));
                    return "error";
                }
            }
            catch (NumberFormatException e) {
                this.addError("hoursPerDay", this.getText("admin.globalsettings.timetracking.error.invalidformat"));
                return "error";
            }
            catch (ArithmeticException e) {
                this.addError("hoursPerDay", this.getText("admin.globalsettings.timetracking.error.toomuchprecision"));
                return "error";
            }
            try {
                BigDecimal daysPerWeek = new BigDecimal(this.getDaysPerWeek());
                daysPerWeek.setScale(2, RoundingMode.UNNECESSARY);
                if (daysPerWeek.equals(BigDecimal.ZERO) || !daysPerWeek.abs().equals(daysPerWeek)) {
                    this.addError("daysPerWeek", this.getText("admin.globalsettings.timetracking.error.notpositive"));
                    return "error";
                }
            }
            catch (NumberFormatException e) {
                this.addError("daysPerWeek", this.getText("admin.globalsettings.timetracking.error.invalidformat"));
                return "error";
            }
            catch (ArithmeticException e) {
                this.addError("daysPerWeek", this.getText("admin.globalsettings.timetracking.error.toomuchprecision"));
                return "error";
            }
            this.applicationProperties.setOption("jira.option.timetracking", true);
            this.applicationProperties.setString("jira.timetracking.hours.per.day", this.getHoursPerDay());
            this.applicationProperties.setString("jira.timetracking.days.per.week", this.getDaysPerWeek());
            this.applicationProperties.setString("jira.timetracking.format", this.getTimeTrackingFormat());
            this.applicationProperties.setString("jira.timetracking.default.unit", this.getDefaultUnit().toUpperCase());
            this.applicationProperties.setOption("jira.timetracking.estimates.legacy.behaviour", this.legacyModeSetter);
            this.applicationProperties.setOption("jira.timetracking.copy.comment.to.work.desc.on.transition", this.isCopyComment);
            this.jiraDurationUtils.updateFormatters(this.applicationProperties, this.authenticationContext);
            this.fieldManager.refresh();
            this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.timetracking");
        }
        return this.getRedirect("TimeTrackingAdmin!default.jspa");
    }

    public String getHoursPerDay() {
        return this.hoursPerDay;
    }

    public void setHoursPerDay(String hoursPerDay) {
        this.hoursPerDay = hoursPerDay;
    }

    public String getDefaultUnit() {
        return this.defaultUnit.toString().toUpperCase();
    }

    public String getDefaultUnitText() {
        Map map = MapBuilder.newBuilder().add((Object)DateUtils.Duration.MINUTE, (Object)this.getText("core.dateutils.minute")).add((Object)DateUtils.Duration.HOUR, (Object)this.getText("core.dateutils.hour")).add((Object)DateUtils.Duration.DAY, (Object)this.getText("core.dateutils.day")).add((Object)DateUtils.Duration.WEEK, (Object)this.getText("core.dateutils.week")).toMap();
        return (String)map.get(this.defaultUnit);
    }

    public void setDefaultUnit(String unit) {
        try {
            this.defaultUnit = DateUtils.Duration.valueOf((String)unit.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.defaultUnit = DateUtils.Duration.MINUTE;
        }
    }

    public String getDaysPerWeek() {
        return this.daysPerWeek;
    }

    public void setDaysPerWeek(String daysPerWeek) {
        this.daysPerWeek = daysPerWeek;
    }

    public Map<String, String> getUnits() {
        return MapBuilder.newBuilder().add((Object)DateUtils.Duration.MINUTE.toString().toUpperCase(), (Object)this.getText("core.dateutils.minute")).add((Object)DateUtils.Duration.HOUR.toString().toUpperCase(), (Object)this.getText("core.dateutils.hour")).add((Object)DateUtils.Duration.DAY.toString().toUpperCase(), (Object)this.getText("core.dateutils.day")).add((Object)DateUtils.Duration.WEEK.toString().toUpperCase(), (Object)this.getText("core.dateutils.week")).toListOrderedMap();
    }

    public List<TextOption> getTimeTrackingFormats() {
        try {
            BigDecimal hoursPerDay = new BigDecimal(this.getHoursPerDay());
            BigDecimal daysPerWeek = new BigDecimal(this.getDaysPerWeek());
            I18nHelper i18nBean = this.authenticationContext.getI18nHelper();
            String durationPretty = new JiraDurationUtils.PrettyDurationFormatter(hoursPerDay, daysPerWeek, i18nBean).format(SAMPLE_DURATION);
            String durationDays = new JiraDurationUtils.DaysDurationFormatter(hoursPerDay, i18nBean).format(SAMPLE_DURATION);
            String durationHours = new JiraDurationUtils.HoursDurationFormatter(i18nBean).format(SAMPLE_DURATION);
            return CollectionBuilder.newBuilder((Object[])new TextOption[]{new TextOption("pretty", this.getText("admin.globalsettings.timetracking.format.pretty", durationPretty)), new TextOption("days", this.getText("admin.globalsettings.timetracking.format.days", durationDays)), new TextOption("hours", this.getText("admin.globalsettings.timetracking.format.hours", durationHours))}).asList();
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            return Collections.emptyList();
        }
    }

    public String getTimeTrackingFormatSample() {
        return this.getText(this.jiraDurationUtils.getI18nKey(), this.jiraDurationUtils.getFormattedDuration(SAMPLE_DURATION));
    }

    public String getTimeTrackingFormat() {
        return this.timeTrackingFormat;
    }

    public void setTimeTrackingFormat(String timeTrackingFormat) {
        this.timeTrackingFormat = timeTrackingFormat;
    }

    public boolean isLegacyMode() {
        return this.legacyModeGetter;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyModeSetter = legacyMode;
    }

    public boolean isCopyComment() {
        return this.isCopyComment;
    }

    public void setCopyComment(boolean copyComment) {
        this.isCopyComment = copyComment;
    }
}

