/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.scheduler.cron.CronValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.export.ExportService;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.scheduler.SchedulerService;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;
import webwork.action.ParameterAware;

@WebSudoRequired
public class EditService
extends JiraWebActionSupport
implements ParameterAware {
    private final ServiceManager serviceManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SchedulerService schedulerService;
    private Long id;
    private Map params;
    private long delay;
    private CronEditorBean cronEditorBean;
    private ObjectConfiguration oc;
    private String removedPath;
    private JiraServiceContainer service = null;
    private static final Set<String> BANNED_KEYS = new HashSet<String>();

    public EditService(ServiceManager serviceManager, JiraAuthenticationContext authenticationContext, SchedulerService schedulerService) {
        this.serviceManager = serviceManager;
        this.authenticationContext = authenticationContext;
        this.schedulerService = schedulerService;
    }

    public String doDefault() throws Exception {
        if (this.canEditService(this.id)) {
            this.delay = this.getService().getDelay() / 60000L;
            this.getObjectConfigurationKeys();
            return "input";
        }
        return "securitybreach";
    }

    private boolean canEditService(final Long serviceId) throws Exception {
        return Iterables.any((Iterable)this.serviceManager.getServicesManageableBy(this.getLoggedInUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser.getId());
            }
        });
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.canEditService(this.id)) {
            try {
                String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
                this.serviceManager.editService(this.id, cronExpression, this.primeParamsWithSavedValues(this.params));
            }
            catch (Exception e) {
                this.log.error((Object)("Error occurred trying to update service properties: " + e), (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.error.occured.trying.to.update.service.properties", e));
            }
            if (this.getHasErrorMessages()) {
                return "error";
            }
            return this.getRedirect("ViewServices!default.jspa");
        }
        return "securitybreach";
    }

    private Map<String, String[]> primeParamsWithSavedValues(Map<String, String[]> webParameters) throws Exception {
        HashMap<String, String[]> newParameters = new HashMap<String, String[]>();
        newParameters.putAll(webParameters);
        for (String bannedKey : BANNED_KEYS) {
            String value = this.getParamValue(bannedKey);
            if (!StringUtils.isNotBlank((String)value)) continue;
            newParameters.put(bannedKey, new String[]{value});
        }
        return newParameters;
    }

    protected void doValidation() {
        if (!this.serviceManager.containsServiceWithId(this.id)) {
            this.addErrorMessage(this.getText("admin.errors.service.does.not.exist"));
        }
        if (this.params.containsKey("subdirectory")) {
            try {
                String subdirectory = ((String[])this.params.get("subdirectory"))[0];
                File subdirectoryFile = new File(this.getJiraHome().getHome(), PathUtils.joinPaths((String[])new String[]{FileService.MAIL_DIR, subdirectory})).getCanonicalFile();
                File mailDir = new File(this.getJiraHome().getHome(), FileService.MAIL_DIR).getCanonicalFile();
                if (!subdirectoryFile.getParentFile().equals(mailDir) && !subdirectoryFile.equals(mailDir)) {
                    this.addError("subdirectory", this.getText("admin.errors.fileservice.directory.is.not.subdirectory"));
                }
                if (!subdirectoryFile.exists()) {
                    this.addError("subdirectory", this.getText("admin.errors.fileservice.directory.not.exist"));
                }
            }
            catch (Exception e) {
                this.addError("subdirectory", this.getText("admin.errors.fileservice.could.not.find"));
            }
        }
        this.cronEditorBean = new CronEditorBean("service.schedule", ActionContext.getParameters());
        CronEditorWebComponent component = new CronEditorWebComponent();
        this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            String cronString = component.getCronExpressionFromInput(this.cronEditorBean);
            Option<String> cronError = new CronValidator(this.authenticationContext.getI18nHelper(), this.schedulerService).validateCron(cronString);
            if (cronError.isDefined()) {
                serviceContext.getErrorCollection().addError("cron.editor.name", (String)cronError.get());
            }
        }
        super.doValidation();
    }

    public boolean isUnsafeService(long serviceId) {
        try {
            if (this.serviceManager.containsServiceWithId(Long.valueOf(serviceId))) {
                JiraServiceContainer serviceWithId = this.serviceManager.getServiceWithId(Long.valueOf(serviceId));
                String serviceClass = serviceWithId.getServiceClass();
                return "com.atlassian.jira.service.services.export.ExportService".equals(serviceClass) || "com.atlassian.jira.service.services.file.FileService".equals(serviceClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public ObjectConfiguration getObjectConfiguration() throws Exception {
        if (this.oc == null) {
            this.oc = this.getService().getObjectConfiguration();
        }
        return this.oc;
    }

    public String[] getObjectConfigurationKeys() throws Exception {
        String[] fieldKeys = this.getObjectConfiguration().getFieldKeys();
        ArrayList<String> sanitizedFieldKeys = new ArrayList<String>(fieldKeys.length);
        for (String fieldKey : fieldKeys) {
            if (this.id != null && !this.isBannedKey(this.id, fieldKey)) {
                sanitizedFieldKeys.add(fieldKey);
                continue;
            }
            this.removedPath = this.getParamValue(fieldKey);
        }
        if (this.removedPath == null && this.getService().getServiceClass().equals(ExportService.class.getCanonicalName())) {
            sanitizedFieldKeys.remove("USE_DEFAULT_DIRECTORY");
        }
        return sanitizedFieldKeys.toArray(new String[sanitizedFieldKeys.size()]);
    }

    private boolean isBannedKey(long serviceId, String fieldKey) {
        return this.isUnsafeService(serviceId) && BANNED_KEYS.contains(fieldKey);
    }

    private Map sanitizeParams(Map<String, String[]> parameters) {
        HashMap<String, String[]> sanitizedMap = new HashMap<String, String[]>();
        sanitizedMap.putAll(parameters);
        String[] idParam = parameters.get("id");
        if (idParam != null && idParam.length > 0) {
            Long serviceId = Long.parseLong(idParam[0]);
            Iterator iterator = sanitizedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.isBannedKey(serviceId, (String)entry.getKey())) continue;
                iterator.remove();
            }
        }
        return sanitizedMap;
    }

    public void setParameters(Map map) {
        this.params = this.sanitizeParams(map);
    }

    public Map getParameters() {
        return this.params;
    }

    public String getParamValue(String s) throws Exception {
        if (this.getService().getProperties() != null) {
            return this.getService().getProperty(s);
        }
        return "";
    }

    public List getParamValues(String key) {
        Map inputParams = this.getParameters();
        if (inputParams == null) {
            return this.getDefaultValue(key);
        }
        Object val = inputParams.get(key);
        if (val == null) {
            return this.getDefaultValue(key);
        }
        if (val instanceof String[]) {
            return Arrays.asList((String[])val);
        }
        return Arrays.asList(val.toString());
    }

    private List getDefaultValue(String key) {
        try {
            String s = this.getObjectConfiguration().getFieldDefault(key);
            return s == null ? Collections.emptyList() : Arrays.asList(s);
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to obtain default value for '" + key + "'. Using empy value."), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public JiraServiceContainer getService() throws Exception {
        if (this.service == null) {
            this.service = this.serviceManager.getServiceWithId(this.id);
        }
        return this.service;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getDescription() throws Exception {
        return this.getObjectConfiguration().getDescription(null);
    }

    public String getRemovedPath() {
        return this.removedPath;
    }

    public boolean isValidMailParameters() {
        if (!JiraSystemProperties.isDecodeMailParameters() && this.id != null) {
            try {
                JiraServiceContainer serviceContainer = this.getService();
                if (serviceContainer != null) {
                    ImmutableSet mailServices = ImmutableSet.of((Object)MailFetcherService.class.getName(), (Object)FileService.class.getName());
                    return !mailServices.contains(serviceContainer.getServiceClass());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private JiraHome getJiraHome() {
        return (JiraHome)ComponentAccessor.getComponentOfType(JiraHome.class);
    }

    public String getFileServiceBasePath() {
        return PathUtils.appendFileSeparator((String)PathUtils.joinPaths((String[])new String[]{"[jira.home]", FileService.MAIL_DIR}));
    }

    public CronEditorBean getCronEditorBean() throws Exception {
        if (this.cronEditorBean == null) {
            this.cronEditorBean = new CronExpressionParser(this.getService().getCronExpression()).getCronEditorBean();
        }
        return this.cronEditorBean;
    }

    public String getHelpLink() {
        return "services";
    }

    static {
        BANNED_KEYS.add("DIR_NAME");
        BANNED_KEYS.add("directory");
    }
}

