/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.thread;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.util.thread.OffRequestThreadExecutor;
import org.apache.log4j.Logger;

public class OffRequestThreadExecutorImpl
implements OffRequestThreadExecutor {
    private static final Logger log = Logger.getLogger(OffRequestThreadExecutorImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public OffRequestThreadExecutorImpl(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void execute(Runnable command) {
        this.execute(null, command);
    }

    public void execute(ApplicationUser runAsUser, Runnable command) {
        try {
            this.preCall(runAsUser);
            command.run();
        }
        finally {
            this.postCall(command);
        }
    }

    private void preCall(ApplicationUser runAsUser) {
        JiraThreadLocalUtils.preCall();
        this.jiraAuthenticationContext.setLoggedInUser(runAsUser);
    }

    private void postCall(final Runnable command) {
        this.jiraAuthenticationContext.setLoggedInUser((ApplicationUser)null);
        JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtil.WarningCallback(){

            public void onOpenTransaction() {
                log.error((Object)("A database connection was left open by the code : " + command.getClass().getName()));
            }
        });
    }
}

